/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import java.util.Objects;

public class Difference {
    private final String fullPath;
    private final Type type;

    public Difference(Type type, String fullPath) {
        this.fullPath = fullPath;
        this.type = type;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Difference that = (Difference)o;
        return Objects.equals(this.fullPath, that.fullPath) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fullPath, this.type});
    }

    private String error() {
        Object errorDescription = "";
        switch (this.type) {
            case PACKAGE_CHANGED: {
                errorDescription = "The package at '" + this.fullPath + "' in the %s schema does not match the package in the %s schema";
                break;
            }
            case MESSAGE_REMOVED: {
                errorDescription = "The %s schema is missing a MESSAGE type at path '" + this.fullPath + "' in the %s schema";
                break;
            }
            case FIELD_KIND_CHANGED: {
                errorDescription = "The type of a field at path '" + this.fullPath + "' in the %s schema does not match the %s schema";
                break;
            }
            case FIELD_SCALAR_KIND_CHANGED: {
                errorDescription = "The kind of a SCALAR field at path '" + this.fullPath + "' in the %s schema does not match its kind in the %s schema";
                break;
            }
            case FIELD_NAMED_TYPE_CHANGED: {
                errorDescription = "The type of a MESSAGE field at path '" + this.fullPath + "' in the %s schema does not match its type in the %s schema";
                break;
            }
            case FIELD_NUMERIC_LABEL_CHANGED: {
                errorDescription = "The label for a NUMERIC field at path '" + this.fullPath + "' in the %s schema does not match its label in the %s schema";
                break;
            }
            case REQUIRED_FIELD_ADDED: {
                errorDescription = "A required field  at path '" + this.fullPath + "' in the %s schema is missing in the %s schema";
                break;
            }
            case REQUIRED_FIELD_REMOVED: {
                errorDescription = "The %s schema is missing a required field at path: '" + this.fullPath + "' in the %s schema";
                break;
            }
            case ONEOF_FIELD_REMOVED: {
                errorDescription = "The %s schema is missing a oneof field at path '" + this.fullPath + "' in the %s schema";
                break;
            }
            case MULTIPLE_FIELDS_MOVED_TO_ONEOF: {
                errorDescription = "Multiple fields in the oneof at path '" + this.fullPath + "' in the %s schema are outside a oneof in the %s schema";
                break;
            }
            case FIELD_MOVED_TO_EXISTING_ONEOF: {
                errorDescription = "A field in the oneof at path '" + this.fullPath + "' in the %s schema is outside an existing oneof in the %s schema";
                break;
            }
            default: {
                errorDescription = "";
            }
        }
        return errorDescription;
    }

    public String toString() {
        return "{errorType:\"" + String.valueOf((Object)this.type) + "\", description:\"" + this.error() + "\"}";
    }

    public static enum Type {
        PACKAGE_CHANGED,
        MESSAGE_ADDED,
        MESSAGE_REMOVED,
        MESSAGE_MOVED,
        ENUM_ADDED,
        ENUM_REMOVED,
        ENUM_CONST_ADDED,
        ENUM_CONST_CHANGED,
        ENUM_CONST_REMOVED,
        FIELD_ADDED,
        FIELD_REMOVED,
        FIELD_NAME_CHANGED,
        FIELD_KIND_CHANGED,
        FIELD_SCALAR_KIND_CHANGED,
        FIELD_NAMED_TYPE_CHANGED,
        FIELD_NUMERIC_LABEL_CHANGED,
        FIELD_STRING_OR_BYTES_LABEL_CHANGED,
        REQUIRED_FIELD_ADDED,
        REQUIRED_FIELD_REMOVED,
        ONEOF_ADDED,
        ONEOF_REMOVED,
        ONEOF_FIELD_ADDED,
        ONEOF_FIELD_REMOVED,
        MULTIPLE_FIELDS_MOVED_TO_ONEOF,
        FIELD_MOVED_TO_EXISTING_ONEOF;

    }
}

