/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonValue;
import io.confluent.kafka.schemaregistry.json.jackson.JsonSkemaBaseSerializer;
import io.confluent.kafka.schemaregistry.json.jackson.JsonSkemaObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class JsonSkemaArraySerializer
extends JsonSkemaBaseSerializer<JsonArray> {
    private static final long serialVersionUID = 1L;
    public static final JsonSkemaArraySerializer instance = new JsonSkemaArraySerializer();

    public JsonSkemaArraySerializer() {
        super(JsonArray.class);
    }

    public boolean isEmpty(SerializerProvider provider, JsonArray value) {
        return value == null || value.length() == 0;
    }

    public void serialize(JsonArray value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeStartArray();
        this.serializeContents(value, g, provider);
        g.writeEndArray();
    }

    public void serializeWithType(JsonArray value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g.setCurrentValue((Object)value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, JsonToken.START_ARRAY));
        this.serializeContents(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("array", true);
    }

    protected void serializeContents(JsonArray value, JsonGenerator g, SerializerProvider provider) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            JsonValue ob = value.get(i);
            if (ob instanceof JsonNull) {
                g.writeNull();
                continue;
            }
            if (ob instanceof JsonObject) {
                JsonSkemaObjectSerializer.instance.serialize((JsonObject)ob, g, provider);
                continue;
            }
            if (ob instanceof JsonArray) {
                this.serialize((JsonArray)ob, g, provider);
                continue;
            }
            if (ob instanceof JsonString) {
                g.writeString(((JsonString)ob).getValue());
                continue;
            }
            if (ob instanceof JsonNumber) {
                Number num = ((JsonNumber)ob).getValue();
                if (num instanceof Double) {
                    g.writeNumber(num.doubleValue());
                    continue;
                }
                if (num instanceof Float) {
                    g.writeNumber(num.floatValue());
                    continue;
                }
                if (num instanceof Long) {
                    g.writeNumber(num.longValue());
                    continue;
                }
                g.writeNumber(num.intValue());
                continue;
            }
            if (ob instanceof JsonBoolean) {
                g.writeBoolean(((JsonBoolean)ob).getValue());
                continue;
            }
            provider.defaultSerializeValue((Object)ob, g);
        }
    }
}

