/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.KafkaConnection;
import io.confluent.kafka.jms.KafkaMessageProducer;
import io.confluent.kafka.jms.KafkaTopic;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.utils.Time;

class KafkaTopicPublisher
extends KafkaMessageProducer
implements TopicPublisher {
    KafkaTopicPublisher(Producer<byte[], byte[]> producer, Time clock, KafkaTopic topic, KafkaConnection connection) {
        super(producer, clock, topic, connection);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.destination;
    }

    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.send((Destination)topic, message);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Destination)topic, message, deliveryMode, priority, timeToLive);
    }
}

