/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.ConfigurationJMSException;
import io.confluent.kafka.jms.JMSClientConfig;
import io.confluent.kafka.jms.KafkaConnection;
import io.confluent.kafka.jms.KafkaTopicSession;
import io.confluent.kafka.jms.Unsupported;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

class KafkaTopicConnection
extends KafkaConnection
implements TopicConnection {
    KafkaTopicConnection(JMSClientConfig jmsClientConfig) {
        super(jmsClientConfig);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        try {
            return new KafkaTopicSession(this, transacted, acknowledgeMode);
        }
        catch (Exception ex) {
            throw new ConfigurationJMSException("Unable to create topic session", ex);
        }
    }

    @Unsupported(value="This is an expert facility not used by regular JMS clients.")
    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        throw new JMSException("This is an expert facility not used by regular JMS clients.");
    }
}

