/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.google.common.base.Charsets;
import io.confluent.kafka.jms.AccessMode;
import io.confluent.kafka.jms.KafkaMessage;
import io.confluent.kafka.jms.KafkaMessageQueue;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;
import org.apache.kafka.clients.consumer.ConsumerRecord;

class KafkaTextMessage
extends KafkaMessage
implements TextMessage {
    public static final String MESSAGE_TYPE = "text";
    String text;
    AccessMode accessMode;

    @Override
    protected String messageType() {
        return MESSAGE_TYPE;
    }

    @Override
    protected byte[] serializeBody() throws JMSException {
        byte[] result = null == this.text ? null : this.text.getBytes(Charsets.UTF_8);
        return result;
    }

    private static String deserializeBody(byte[] body) throws JMSException {
        if (null == body) {
            return null;
        }
        return new String(body, Charsets.UTF_8);
    }

    @Override
    public void clearBody() throws JMSException {
        this.text = null;
        this.accessMode = AccessMode.ReadWrite;
    }

    public KafkaTextMessage(KafkaMessageQueue messageQueue, ConsumerRecord<byte[], byte[]> record, boolean allowOutOfOrderAcknowledge) throws JMSException {
        super(messageQueue, record, allowOutOfOrderAcknowledge);
        this.text = KafkaTextMessage.deserializeBody((byte[])record.value());
        this.accessMode = AccessMode.ReadOnly;
    }

    public KafkaTextMessage() {
        this.text = null;
        this.accessMode = AccessMode.ReadWrite;
    }

    public String getText() throws JMSException {
        return this.text;
    }

    public void setText(String s) throws JMSException {
        if (this.accessMode == AccessMode.ReadOnly) {
            throw new MessageNotWriteableException("Message not writable.");
        }
        this.text = s;
    }
}

