/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.confluent.kafka.jms.AccessMode;
import io.confluent.kafka.jms.JMSIOException;
import io.confluent.kafka.jms.JsonHeaderValue;
import io.confluent.kafka.jms.JsonHeaderValueType;
import io.confluent.kafka.jms.KafkaMessage;
import io.confluent.kafka.jms.KafkaMessageQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaStreamMessage
extends KafkaMessage
implements StreamMessage {
    static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log;
    public static final String MESSAGE_TYPE = "stream";
    List<Object> contents;
    int index;
    AccessMode accessMode;

    public KafkaStreamMessage(KafkaMessageQueue messageQueue, ConsumerRecord<byte[], byte[]> record, boolean allowOutOfOrderAcknowledge) throws JMSException {
        super(messageQueue, record, allowOutOfOrderAcknowledge);
        this.contents = KafkaStreamMessage.deserializeBody((byte[])record.value());
        this.index = 0;
        this.accessMode = AccessMode.ReadOnly;
    }

    public KafkaStreamMessage() {
        this.contents = new ArrayList<Object>(1024);
        this.index = 0;
        this.accessMode = AccessMode.WriteOnly;
    }

    public boolean readBoolean() throws JMSException {
        return this.readObjectInternal(Boolean.class);
    }

    public byte readByte() throws JMSException {
        return this.readObjectInternal(Byte.class);
    }

    public short readShort() throws JMSException {
        return this.readObjectInternal(Short.class);
    }

    public char readChar() throws JMSException {
        return this.readObjectInternal(Character.class).charValue();
    }

    public int readInt() throws JMSException {
        return this.readObjectInternal(Integer.class);
    }

    public long readLong() throws JMSException {
        return this.readObjectInternal(Long.class);
    }

    public float readFloat() throws JMSException {
        return this.readObjectInternal(Float.class).floatValue();
    }

    public double readDouble() throws JMSException {
        return this.readObjectInternal(Double.class);
    }

    public String readString() throws JMSException {
        return this.readObjectInternal(String.class);
    }

    public int readBytes(byte[] bytes) throws JMSException {
        throw new JMSException("KafkaStreamMessage.readBytes() is not supported by this client.");
    }

    public Object readObject() throws JMSException {
        return this.readObjectInternal(Object.class);
    }

    private <T> T readObjectInternal(Class<T> cls) throws JMSException {
        Preconditions.checkNotNull(cls, (Object)"cls should not be null.");
        log.trace("readObjectInternal() - cls = '{}'", (Object)cls.getSimpleName());
        if (this.accessMode == AccessMode.WriteOnly) {
            throw new MessageNotReadableException("Message not readable.");
        }
        if (this.index >= this.contents.size()) {
            throw new MessageEOFException("The end of the message has been reached.");
        }
        Object result = this.contents.get(this.index);
        ++this.index;
        return cls.cast(result);
    }

    public void writeBoolean(boolean value) throws JMSException {
        log.trace("writeBoolean() - value = {}", (Object)value);
        this.writeObject(value);
    }

    public void writeByte(byte value) throws JMSException {
        log.trace("writeByte() - value = {}", (Object)value);
        this.writeObject(value);
    }

    public void writeShort(short value) throws JMSException {
        log.trace("writeShort() - value = {}", (Object)value);
        this.writeObject(value);
    }

    public void writeChar(char value) throws JMSException {
        log.trace("writeChar() - value = {}", (Object)Character.valueOf(value));
        this.writeObject(Character.valueOf(value));
    }

    public void writeInt(int value) throws JMSException {
        log.trace("writeInt() - value = {}", (Object)value);
        this.writeObject(value);
    }

    public void writeLong(long value) throws JMSException {
        log.trace("writeLong() - value = {}", (Object)value);
        this.writeObject(value);
    }

    public void writeFloat(float value) throws JMSException {
        log.trace("writeFloat() - value = {}", (Object)Float.valueOf(value));
        this.writeObject(Float.valueOf(value));
    }

    public void writeDouble(double value) throws JMSException {
        log.trace("writeDouble() - value = {}", (Object)value);
        this.writeObject(value);
    }

    public void writeString(String value) throws JMSException {
        log.trace("writeString() - value = {}", (Object)value);
        this.writeObject(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        log.trace("writeBytes() - value = {}", (Object)value);
        this.writeObject(value);
    }

    public void writeBytes(byte[] value, int index, int length) throws JMSException {
        log.trace("writeBytes() - value = {}", (Object)value);
        byte[] buffer = new byte[length];
        System.arraycopy(value, index, buffer, 0, length);
        this.writeBytes(buffer);
    }

    public void writeObject(Object value) throws JMSException {
        log.trace("writeObject() - value = {}", value);
        if (this.accessMode == AccessMode.ReadOnly) {
            throw new MessageNotWriteableException("Message not writable.");
        }
        this.contents.add(value);
    }

    public void reset() throws JMSException {
        this.accessMode = AccessMode.ReadOnly;
        this.index = 0;
    }

    @Override
    protected String messageType() {
        return MESSAGE_TYPE;
    }

    @Override
    protected byte[] serializeBody() throws JMSException {
        ArrayList<JsonHeaderValue> jsonHeaders = new ArrayList<JsonHeaderValue>(this.contents.size());
        for (Object entry : this.contents) {
            jsonHeaders.add(new JsonHeaderValue(entry));
        }
        try {
            byte[] buffer = JSON_OBJECT_MAPPER.writeValueAsBytes(jsonHeaders);
            if (log.isTraceEnabled()) {
                log.trace("serializeBody() - Serialized as {}", (Object)new String(buffer, Charsets.UTF_8));
            }
            return buffer;
        }
        catch (JsonProcessingException e) {
            throw new JMSIOException("Exception thrown while serializing body.", e);
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.contents.clear();
        this.accessMode = AccessMode.WriteOnly;
        this.index = 0;
    }

    private static List<Object> deserializeBody(byte[] body) throws JMSException {
        try {
            List jsonHeaders = (List)JSON_OBJECT_MAPPER.readValue(body, (TypeReference)new TypeReference<List<JsonHeaderValue>>(){});
            ArrayList<Object> contents = new ArrayList<Object>(jsonHeaders.size());
            int index = 0;
            for (JsonHeaderValue jsonHeader : jsonHeaders) {
                Object value = new JsonHeaderValue((JsonHeaderValueType)jsonHeader.type, (Object)jsonHeader.value).value;
                log.trace("deserializeBody() - Adding '{}' to index {}.", value, (Object)index);
                contents.add(value);
                ++index;
            }
            return contents;
        }
        catch (IOException e) {
            throw new JMSIOException("Exception thrown while deserializing body.", e);
        }
    }

    static {
        JSON_OBJECT_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, false);
        JSON_OBJECT_MAPPER.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        log = LoggerFactory.getLogger(KafkaStreamMessage.class);
    }
}

