/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.confluent.kafka.jms.JMSConsumerRebalanceListener;
import io.confluent.kafka.jms.JMSPreconditions;
import io.confluent.kafka.jms.KafkaBytesMessage;
import io.confluent.kafka.jms.KafkaConnection;
import io.confluent.kafka.jms.KafkaDestination;
import io.confluent.kafka.jms.KafkaMapMessage;
import io.confluent.kafka.jms.KafkaMessageConsumer;
import io.confluent.kafka.jms.KafkaMessageProducer;
import io.confluent.kafka.jms.KafkaMessageQueue;
import io.confluent.kafka.jms.KafkaObjectMessage;
import io.confluent.kafka.jms.KafkaQueue;
import io.confluent.kafka.jms.KafkaQueueBrowser;
import io.confluent.kafka.jms.KafkaStreamMessage;
import io.confluent.kafka.jms.KafkaTextMessage;
import io.confluent.kafka.jms.KafkaTopic;
import io.confluent.kafka.jms.Unsupported;
import java.io.Serializable;
import java.util.Collections;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaSession
implements Session {
    static final Logger log = LoggerFactory.getLogger(KafkaSession.class);
    final String sessionId = UUID.randomUUID().toString();
    final int acknowledgeMode;
    final KafkaConnection connection;
    Time clock = new SystemTime();

    public KafkaSession(KafkaConnection connection, boolean transacted, int acknowledgeMode) {
        if (transacted) {
            log.warn("A transacted session was created, but transactions are not supported by this client. Transaction related method calls will have no effect.");
        }
        this.acknowledgeMode = acknowledgeMode;
        this.connection = connection;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return new KafkaBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return new KafkaMapMessage();
    }

    public Message createMessage() throws JMSException {
        return new KafkaTextMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return new KafkaObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        ObjectMessage message = this.createObjectMessage();
        message.setObject(serializable);
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return new KafkaStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return new KafkaTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        TextMessage message = this.createTextMessage();
        message.setText(text);
        return message;
    }

    public boolean getTransacted() throws JMSException {
        return false;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.acknowledgeMode;
    }

    @Unsupported(value="Transactions are not supported by this client")
    public void commit() throws JMSException {
    }

    @Unsupported(value="Transactions are not supported by this client")
    public void rollback() throws JMSException {
    }

    public void close() throws JMSException {
        log.trace("close()");
        this.connection.closeSessionClients(this);
    }

    @Unsupported(value="Transactions are not supported by this client")
    public void recover() throws JMSException {
    }

    @Unsupported(value="Session based MessageListeners are not supported.")
    public MessageListener getMessageListener() throws JMSException {
        return null;
    }

    @Unsupported(value="Session based MessageListeners are not supported.")
    public void setMessageListener(MessageListener messageListener) throws JMSException {
    }

    @Unsupported(value="Optional operation, intended to be used only by Application Servers, not by ordinary JMS clients.")
    public void run() {
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        KafkaDestination kafkaDestination = JMSPreconditions.checkDestination(destination);
        Producer<byte[], byte[]> producer = this.connection.producerFactory.create();
        KafkaMessageProducer messageProducer = new KafkaMessageProducer(producer, this.clock, kafkaDestination, this.connection);
        this.connection.registerProducer(this, messageProducer);
        return messageProducer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    @Unsupported(value="Message selectors are not not supported. An exception will be thrown if one is set.")
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    @Unsupported(value="Message selectors are not not supported. An exception will be thrown if one is set.")
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (null != messageSelector) {
            throw new JMSException("messageSelectors are not supported by this client.");
        }
        if (noLocal) {
            log.warn("KafkaSession.createConsumer: noLocal parameter was set to true, but this ignored.");
        }
        KafkaDestination kafkaDestination = JMSPreconditions.checkDestination(destination);
        Consumer consumer = this.connection.consumerFactory.create(destination instanceof Queue);
        KafkaMessageConsumer messageConsumer = new KafkaMessageConsumer(this.connection.jmsClientConfig, (Consumer<byte[], byte[]>)consumer, kafkaDestination, this);
        this.connection.registerConsumer(this, messageConsumer);
        return messageConsumer;
    }

    public Queue createQueue(String queueName) throws JMSException {
        Preconditions.checkNotNull((Object)queueName, (Object)"queueName cannot be null");
        return new KafkaQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        Preconditions.checkNotNull((Object)topicName, (Object)"topicName cannot be null");
        return new KafkaTopic(topicName);
    }

    @Unsupported(value="Durable Subscribers are not supported.")
    public TopicSubscriber createDurableSubscriber(Topic topic, String s) throws JMSException {
        throw new JMSException("Durable Subscribers are not supported by this client.");
    }

    @Unsupported(value="Durable Subscribers are not supported.")
    public TopicSubscriber createDurableSubscriber(Topic topic, String s, String s1, boolean b) throws JMSException {
        throw new JMSException("Durable Subscribers are not supported by this client.");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    @Unsupported(value="QueueBrowsers with message selectors are not supported.")
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (!Strings.isNullOrEmpty((String)messageSelector)) {
            throw new JMSException("QueueBrowsers with message selectors are not supported by this client.");
        }
        KafkaQueue kafkaQueue = (KafkaQueue)JMSPreconditions.checkDestination((Destination)queue);
        Consumer consumer = this.connection.consumerFactory.create(true);
        KafkaMessageQueue messageQueue = new KafkaMessageQueue(this.connection.jmsClientConfig, (Consumer<byte[], byte[]>)consumer, this.connection);
        if (kafkaQueue.topic.startsWith("regex(") && kafkaQueue.topic.endsWith(")")) {
            String regexStr = kafkaQueue.topic.substring("regex(".length(), kafkaQueue.topic.length() - ")".length());
            consumer.subscribe(Pattern.compile(regexStr), (ConsumerRebalanceListener)new JMSConsumerRebalanceListener(messageQueue));
        } else {
            consumer.subscribe(Collections.singletonList(kafkaQueue.topic), (ConsumerRebalanceListener)new JMSConsumerRebalanceListener(messageQueue));
        }
        return new KafkaQueueBrowser(kafkaQueue, messageSelector, messageQueue);
    }

    @Unsupported(value="Kafka does not have a concept of a temporary queue.")
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new JMSException("Kafka does not have a concept of a temporary queue.");
    }

    @Unsupported(value="Kafka does not have a concept of a temporary topic.")
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new JMSException("Kafka does not have a concept of a temporary topic.");
    }

    @Unsupported(value="Durable Subscribers are not supported.")
    public void unsubscribe(String s) throws JMSException {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KafkaSession)) {
            return false;
        }
        KafkaSession that = (KafkaSession)obj;
        return this.sessionId.equals(that.sessionId);
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }
}

