/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import javax.jms.Destination;

class KafkaDestination
implements Destination,
Comparable<KafkaDestination>,
Serializable {
    private static final long serialVersionUID = 1L;
    final String topic;

    public KafkaDestination(String topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"topic cannot be null");
        this.topic = topic;
    }

    @Override
    public int compareTo(KafkaDestination that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.topic), (Comparable)((Object)that.topic)).result();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.topic});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KafkaDestination)) {
            return false;
        }
        return this.compareTo((KafkaDestination)obj) == 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).toString();
    }
}

