/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import io.confluent.kafka.jms.JsonDestination;
import io.confluent.kafka.jms.JsonHeaderValueType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class JsonHeaderValue {
    static final Map<Class<?>, JsonHeaderValueType> TYPE_LOOKUP;
    static final ObjectMapper JSON_OBJECT_MAPPER;
    @JsonProperty(value="type")
    JsonHeaderValueType type;
    @JsonProperty(value="value")
    Object value;

    public JsonHeaderValue() {
    }

    public JsonHeaderValue(JsonHeaderValueType type, Object value) {
        this.type = type;
        this.value = JsonHeaderValue.convertedValue(type, value);
    }

    public JsonHeaderValue(Object value) {
        this.value = value;
        if (value == null) {
            this.type = JsonHeaderValueType.STRING;
            return;
        }
        Preconditions.checkState((boolean)TYPE_LOOKUP.containsKey(value.getClass()), (String)"'%s' is not a supported type.", (Object)value.getClass().getSimpleName());
        this.type = TYPE_LOOKUP.get(value.getClass());
    }

    public JsonHeaderValue(byte[] v) {
        try {
            if (null == v) {
                this.type = JsonHeaderValueType.STRING;
                this.value = null;
            } else {
                JsonHeaderValue jsonHeader = (JsonHeaderValue)JSON_OBJECT_MAPPER.readValue(v, JsonHeaderValue.class);
                this.type = jsonHeader.type;
                this.value = JsonHeaderValue.convertedValue(this.type, jsonHeader.value);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not deserialize.", e);
        }
    }

    static Object convertedValue(JsonHeaderValueType type, Object value) {
        switch (type) {
            case BOOLEAN: {
                return (boolean)((Boolean)value);
            }
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case SHORT: {
                return ((Number)value).shortValue();
            }
            case CHAR: {
                return Character.valueOf(((String)value).charAt(0));
            }
            case INT: {
                return ((Number)value).intValue();
            }
            case LONG: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case STRING: {
                return (String)value;
            }
            case DESTINATION: {
                if (value instanceof JsonDestination) {
                    return (JsonDestination)value;
                }
                if (value instanceof Map) {
                    JsonDestination r = new JsonDestination();
                    r.type = (String)((Map)value).get("type");
                    r.name = (String)((Map)value).get("name");
                    return r;
                }
                throw new UnsupportedOperationException("unable to interpret '" + value.getClass().toString() + "' as DESTINATION");
            }
            case BYTEARRAY: {
                if (value instanceof String) {
                    return BaseEncoding.base64().decode((CharSequence)value);
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException(String.format("'%s' is not a supported type.", new Object[]{type}));
    }

    public byte[] asBytes() {
        try {
            return JSON_OBJECT_MAPPER.writeValueAsBytes((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Exception thrown serializing header.", e);
        }
    }

    static {
        JSON_OBJECT_MAPPER = new ObjectMapper();
        JSON_OBJECT_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, false);
        JSON_OBJECT_MAPPER.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        HashMap<Class<JsonDestination>, JsonHeaderValueType> typeLookup = new HashMap<Class<JsonDestination>, JsonHeaderValueType>();
        typeLookup.put(Byte.class, JsonHeaderValueType.BYTE);
        typeLookup.put(Short.class, JsonHeaderValueType.SHORT);
        typeLookup.put(Integer.class, JsonHeaderValueType.INT);
        typeLookup.put(Long.class, JsonHeaderValueType.LONG);
        typeLookup.put(Float.class, JsonHeaderValueType.FLOAT);
        typeLookup.put(Double.class, JsonHeaderValueType.DOUBLE);
        typeLookup.put(String.class, JsonHeaderValueType.STRING);
        typeLookup.put(byte[].class, JsonHeaderValueType.BYTEARRAY);
        typeLookup.put(Boolean.class, JsonHeaderValueType.BOOLEAN);
        typeLookup.put(Character.class, JsonHeaderValueType.CHAR);
        typeLookup.put(JsonDestination.class, JsonHeaderValueType.DESTINATION);
        TYPE_LOOKUP = ImmutableMap.copyOf(typeLookup);
    }
}

