/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.JMSClientConfig;
import io.confluent.kafka.jms.LicenseValidator;
import java.util.concurrent.TimeUnit;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import scala.Tuple2;

class ZkTrialPeriod {
    static final String TRIAL_PERIOD_ZK_PATH = "/confluent-jms-client/license-trial";
    static final long TRIAL_LIMIT_MS = TimeUnit.DAYS.toMillis(30L);
    private final JMSClientConfig config;
    private final Time time;

    ZkTrialPeriod(JMSClientConfig config, Time time) {
        this.config = config;
        this.time = time;
    }

    long startOrVerify() throws LicenseValidator.ValidationConnectionException {
        if (this.config.zookeeperConnect == null) {
            throw new LicenseValidator.ValidationConnectionException("The zookeeper.connect configuration property must be set to enable trial mode.");
        }
        ZkUtils zkUtils = ZkUtils.apply((String)this.config.zookeeperConnect, (int)this.config.zookeeperSessionTimeoutMs, (int)this.config.zookeeperConnectTimeoutMs, (boolean)JaasUtils.isZkSecurityEnabled());
        try {
            zkUtils.createPersistentPath(TRIAL_PERIOD_ZK_PATH, "", ZkUtils$.MODULE$.DefaultAcls(zkUtils.isSecure()));
            return TRIAL_LIMIT_MS;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            Tuple2 readResult = zkUtils.readDataMaybeNull(TRIAL_PERIOD_ZK_PATH);
            Stat stat = (Stat)readResult._2();
            long elapsedTime = Math.max(this.time.milliseconds() - stat.getCtime(), 0L);
            long remainingTime = Math.max(TRIAL_LIMIT_MS - elapsedTime, 0L);
            return remainingTime;
        }
    }
}

