/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.JMSPreconditions;
import io.confluent.kafka.jms.KafkaConnection;
import io.confluent.kafka.jms.KafkaSession;
import io.confluent.kafka.jms.KafkaTopic;
import io.confluent.kafka.jms.KafkaTopicPublisher;
import io.confluent.kafka.jms.KafkaTopicSubscriber;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;

class KafkaTopicSession
extends KafkaSession
implements TopicSession {
    public KafkaTopicSession(KafkaConnection connection, boolean transacted, int acknowledgeMode) {
        super(connection, transacted, acknowledgeMode);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        if (null != messageSelector) {
            throw new JMSException("messageSelectors are not implemented by this client.");
        }
        if (noLocal) {
            log.warn("KafkaTopicSession.createConsumer: noLocal parameter was set to true, but this ignored.");
        }
        KafkaTopic kafkaTopic = (KafkaTopic)JMSPreconditions.checkDestination((Destination)topic);
        Consumer consumer = this.connection.consumerFactory.create(false);
        KafkaTopicSubscriber topicSubscriber = new KafkaTopicSubscriber(this.connection.jmsClientConfig, (Consumer<byte[], byte[]>)consumer, kafkaTopic, (KafkaSession)this);
        this.connection.registerConsumer(this, topicSubscriber);
        return topicSubscriber;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        KafkaTopic kafkaTopic = (KafkaTopic)JMSPreconditions.checkDestination((Destination)topic);
        Producer<byte[], byte[]> producer = this.connection.producerFactory.create();
        KafkaTopicPublisher messagePublisher = new KafkaTopicPublisher(producer, this.clock, kafkaTopic, this.connection);
        this.connection.registerProducer(this, messagePublisher);
        return messagePublisher;
    }
}

