/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.ConfigurationJMSException;
import io.confluent.kafka.jms.JMSClientConfig;
import io.confluent.kafka.jms.KafkaConnection;
import io.confluent.kafka.jms.KafkaQueueSession;
import io.confluent.kafka.jms.Unsupported;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;

class KafkaQueueConnection
extends KafkaConnection
implements QueueConnection {
    KafkaQueueConnection(JMSClientConfig jmsClientConfig) {
        super(jmsClientConfig);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        try {
            return new KafkaQueueSession(this, transacted, acknowledgeMode);
        }
        catch (Exception ex) {
            throw new ConfigurationJMSException("Unable to create queue session", ex);
        }
    }

    @Unsupported(value="This is an expert facility not used by regular JMS clients.")
    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        throw new JMSException("This is an expert facility not used by regular JMS clients.");
    }
}

