/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.google.common.base.Preconditions;
import io.confluent.kafka.jms.JsonHeader;
import io.confluent.kafka.jms.KafkaBytesMessage;
import io.confluent.kafka.jms.KafkaMapMessage;
import io.confluent.kafka.jms.KafkaMessage;
import io.confluent.kafka.jms.KafkaMessageQueue;
import io.confluent.kafka.jms.KafkaObjectMessage;
import io.confluent.kafka.jms.KafkaStreamMessage;
import io.confluent.kafka.jms.KafkaTextMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaMessageFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaMessageFactory.class);

    KafkaMessageFactory() {
    }

    public static Message createMessage(String fallbackMessageType, boolean allowOutOfOrderAcknowledge, KafkaMessageQueue messageQueue, ConsumerRecord<byte[], byte[]> record) throws JMSException {
        KafkaMessage result;
        String messageType;
        JsonHeader messageTypeHeader;
        Preconditions.checkNotNull((Object)record.headers(), (Object)"record.headers() cannot be null");
        Header header = record.headers().lastHeader("jms.message.type");
        JsonHeader jsonHeader = messageTypeHeader = header != null ? new JsonHeader(header) : null;
        if (null != messageTypeHeader) {
            messageType = (String)messageTypeHeader.getTypedValue().value;
        } else {
            messageType = fallbackMessageType;
            log.trace("createMessage() - Header {} not set. Using fallback of '{}'", (Object)"jms.message.type", (Object)messageType);
        }
        Preconditions.checkNotNull((Object)messageType, (String)"message must specify the message type in the header '%s'", (Object)"jms.message.type");
        switch (messageType) {
            case "text": {
                result = new KafkaTextMessage(messageQueue, record, allowOutOfOrderAcknowledge);
                break;
            }
            case "bytes": {
                result = new KafkaBytesMessage(messageQueue, record, allowOutOfOrderAcknowledge);
                break;
            }
            case "object": {
                result = new KafkaObjectMessage(messageQueue, record, allowOutOfOrderAcknowledge);
                break;
            }
            case "map": {
                result = new KafkaMapMessage(messageQueue, record, allowOutOfOrderAcknowledge);
                break;
            }
            case "stream": {
                result = new KafkaStreamMessage(messageQueue, record, allowOutOfOrderAcknowledge);
                break;
            }
            default: {
                throw new JMSException(String.format("The %s '%s' is not supported", "jms.message.type", messageType));
            }
        }
        return result;
    }
}

