/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.ClusterSizeProvider;
import io.confluent.kafka.jms.ClusterSizeProviderImpl;
import io.confluent.kafka.jms.DefaultLicenseValidator;
import io.confluent.kafka.jms.JMSClientConfig;
import io.confluent.kafka.jms.KafkaConnection;
import io.confluent.kafka.jms.KafkaQueueConnection;
import io.confluent.kafka.jms.KafkaTopicConnection;
import io.confluent.kafka.jms.LicenseExpiredException;
import io.confluent.kafka.jms.LicenseValidator;
import io.confluent.kafka.jms.Unsupported;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConnectionFactory
implements ConnectionFactory,
TopicConnectionFactory,
QueueConnectionFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(KafkaConnectionFactory.class);
    JMSClientConfig config;
    LicenseValidator licenseValidator;
    ClusterSizeProvider clusterSizeProvider;
    Time time;
    static final long LICENSE_WARNING_DAYS = 15L;
    static final long LICENSE_EXPIRING_WARNING = TimeUnit.DAYS.toMillis(15L);

    KafkaConnectionFactory(JMSClientConfig config) {
        this.config = config;
        this.time = new SystemTime();
        this.licenseValidator = new DefaultLicenseValidator(this.config, this.time);
        this.clusterSizeProvider = new ClusterSizeProviderImpl(this.config.adminClient);
    }

    public KafkaConnectionFactory(Map<String, Object> settings) {
        this(new JMSClientConfig(settings));
    }

    public KafkaConnectionFactory(Properties properties) {
        this(new JMSClientConfig(properties));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.config = new JMSClientConfig((Map)ois.readObject());
        this.time = new SystemTime();
        this.licenseValidator = new DefaultLicenseValidator(this.config, this.time);
        this.clusterSizeProvider = new ClusterSizeProviderImpl(this.config.adminClient);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(new HashMap(this.config.originals()));
    }

    int determineBrokerCount() throws LicenseValidator.ValidationFailedException {
        try {
            return this.clusterSizeProvider.getSize();
        }
        catch (Exception e) {
            throw new LicenseValidator.ValidationFailedException("License validation failed: " + e.getMessage());
        }
    }

    private void validateLicense() throws LicenseExpiredException, LicenseValidator.ValidationFailedException, LicenseValidator.ValidationConnectionException {
        if (this.config.isTrial) {
            long timeRemaining = this.licenseValidator.validateTrialPeriod(this.config.zookeeperConnect);
            if (timeRemaining <= 0L) {
                log.info("Your trial license has expired, determining Kafka broker count.");
                if (this.determineBrokerCount() == 1) {
                    log.info("Single broker cluster detected, usage authorized.");
                } else {
                    throw new LicenseExpiredException("Your trial period has expired. Please purchase a license to continue using this product with multi-broker clusters.");
                }
            }
            if (timeRemaining < LICENSE_EXPIRING_WARNING && this.determineBrokerCount() > 1) {
                log.warn("Your trial license is expiring in less than {} day(s). To continue using this product after the trial period with multi-broker clusters, you will be required to purchace a license.", (Object)15L);
            }
        } else {
            this.licenseValidator.validateLicense(this.config.license);
        }
    }

    public Connection createConnection() throws JMSException {
        this.validateLicense();
        return new KafkaConnection(this.config);
    }

    @Unsupported(value="Creation of connections with credentials specified at runtime is not implemented.")
    public Connection createConnection(String username, String password) throws JMSException {
        if (!this.config.enableCreateConnectionIgnoreAuthenticate) {
            throw new JMSException("Creation of connections with credentials specified at runtime is not implemented.");
        }
        return this.createConnection();
    }

    public QueueConnection createQueueConnection() throws JMSException {
        this.validateLicense();
        return new KafkaQueueConnection(this.config);
    }

    @Unsupported(value="Creation of connections with credentials specified at runtime is not implemented.")
    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        if (!this.config.enableCreateConnectionIgnoreAuthenticate) {
            throw new JMSException("Creation of connections with credentials specified at runtime is not implemented.");
        }
        return this.createQueueConnection();
    }

    public TopicConnection createTopicConnection() throws JMSException {
        this.validateLicense();
        return new KafkaTopicConnection(this.config);
    }

    @Unsupported(value="Creation of connections with credentials specified at runtime is not implemented.")
    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        if (!this.config.enableCreateConnectionIgnoreAuthenticate) {
            throw new JMSException("Creation of connections with credentials specified at runtime is not implemented.");
        }
        return this.createTopicConnection();
    }
}

