/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.JMSClientConfig;
import io.confluent.kafka.jms.LicenseValidator;
import io.confluent.kafka.jms.ZkTrialPeriod;
import io.confluent.license.License;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.kafka.common.utils.Time;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;

class DefaultLicenseValidator
implements LicenseValidator {
    private final JMSClientConfig config;
    private final Time time;

    DefaultLicenseValidator(JMSClientConfig config, Time time) {
        this.config = config;
        this.time = time;
    }

    @Override
    public void validateLicense(String license) throws LicenseValidator.ValidationFailedException {
        PublicKey publicKey;
        try {
            publicKey = License.loadPublicKey();
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("Internal license validation error", e);
        }
        this.validateLicense(license, publicKey);
    }

    void validateLicense(String licenseStr, PublicKey publicKey) throws LicenseValidator.ValidationFailedException {
        long expirationTimeMs;
        JwtClaims claims;
        try {
            claims = License.verify((PublicKey)publicKey, (String)licenseStr);
        }
        catch (InvalidJwtException e) {
            throw new LicenseValidator.ValidationFailedException("Invalid License.", e);
        }
        try {
            expirationTimeMs = License.getExpiration((JwtClaims)claims);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to get license expiration.", e);
        }
        if (this.time.milliseconds() > expirationTimeMs) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            throw new LicenseValidator.ValidationFailedException("License expired on : " + dateFormat.format(new Date(expirationTimeMs)));
        }
    }

    @Override
    public long validateTrialPeriod(String zkConnect) throws LicenseValidator.ValidationConnectionException {
        ZkTrialPeriod trialPeriod = new ZkTrialPeriod(this.config, this.time);
        return trialPeriod.startOrVerify();
    }
}

