/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.util;

import io.confluent.connect.storage.partitioner.DefaultPartitioner;
import io.confluent.connect.storage.partitioner.Partitioner;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.sink.SinkRecord;

public class TombstoneSupportedPartitioner<T>
extends DefaultPartitioner<T> {
    private final Partitioner<T> delegatePartitioner;
    private final String tombstonePartition;

    public TombstoneSupportedPartitioner(Partitioner<T> delegatePartitioner, String tombstonePartition) {
        this.delegatePartitioner = delegatePartitioner;
        this.tombstonePartition = tombstonePartition;
    }

    public void configure(Map<String, Object> map) {
        this.delegatePartitioner.configure(map);
    }

    public String encodePartition(SinkRecord sinkRecord) {
        return sinkRecord.value() == null ? this.tombstonePartition : this.delegatePartitioner.encodePartition(sinkRecord);
    }

    public String generatePartitionedPath(String s, String s1) {
        return this.delegatePartitioner.generatePartitionedPath(s, s1);
    }

    public List<T> partitionFields() {
        return this.delegatePartitioner.partitionFields();
    }
}

