/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.format.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.format.RecordViewSetter;
import io.confluent.connect.s3.format.RecordViews;
import io.confluent.connect.s3.format.S3RetriableRecordWriter;
import io.confluent.connect.s3.format.json.JsonFormat;
import io.confluent.connect.s3.storage.IORecordWriter;
import io.confluent.connect.s3.storage.S3OutputStream;
import io.confluent.connect.s3.storage.S3Storage;
import io.confluent.connect.s3.util.S3ErrorUtils;
import io.confluent.connect.s3.util.Utils;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRecordWriterProvider
extends RecordViewSetter
implements RecordWriterProvider<S3SinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(JsonRecordWriterProvider.class);
    private static final String EXTENSION = ".json";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final byte[] LINE_SEPARATOR_BYTES = LINE_SEPARATOR.getBytes(StandardCharsets.UTF_8);
    private final S3Storage storage;
    private final ObjectMapper mapper;
    private final JsonConverter converter;

    JsonRecordWriterProvider(S3Storage storage, JsonConverter converter) {
        this.storage = storage;
        this.mapper = new ObjectMapper();
        this.converter = converter;
    }

    public String getExtension() {
        return EXTENSION + this.storage.conf().getCompressionType().extension;
    }

    public RecordWriter getRecordWriter(S3SinkConnectorConfig conf, final String filename) {
        try {
            return new S3RetriableRecordWriter(new IORecordWriter(){
                final String adjustedFilename;
                final S3OutputStream s3out;
                final OutputStream s3outWrapper;
                final JsonGenerator writer;
                {
                    this.adjustedFilename = Utils.getAdjustedFilename(JsonRecordWriterProvider.this.recordView, filename, JsonRecordWriterProvider.this.getExtension());
                    this.s3out = JsonRecordWriterProvider.this.storage.create(this.adjustedFilename, true, JsonFormat.class);
                    this.s3outWrapper = this.s3out.wrapForCompression();
                    this.writer = JsonRecordWriterProvider.this.mapper.getFactory().createGenerator(this.s3outWrapper).setRootValueSeparator(null);
                }

                @Override
                public void write(SinkRecord record) throws IOException {
                    log.trace("Sink record with view {}: {}", (Object)JsonRecordWriterProvider.this.recordView, (Object)Utils.sinkRecordToLoggableString(record));
                    boolean envelop = JsonRecordWriterProvider.this.recordView instanceof RecordViews.HeaderRecordView;
                    Object value = JsonRecordWriterProvider.this.recordView.getView(record, envelop);
                    if (value instanceof Struct) {
                        byte[] rawJson = JsonRecordWriterProvider.this.converter.fromConnectData(record.topic(), JsonRecordWriterProvider.this.recordView.getViewSchema(record, envelop), value);
                        this.s3outWrapper.write(rawJson);
                        this.s3outWrapper.write(LINE_SEPARATOR_BYTES);
                    } else {
                        this.writer.writeObject(value);
                        this.writer.writeRaw(LINE_SEPARATOR);
                    }
                }

                @Override
                public void commit() throws IOException {
                    this.writer.flush();
                    this.s3out.commit();
                    this.s3outWrapper.close();
                }

                @Override
                public void close() throws IOException {
                    this.writer.close();
                }
            });
        }
        catch (IOException e) {
            S3ErrorUtils.throwConnectException(e);
            return null;
        }
    }
}

