/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.format.bytearray;

import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.format.RecordViewSetter;
import io.confluent.connect.s3.format.S3RetriableRecordWriter;
import io.confluent.connect.s3.format.bytearray.ByteArrayFormat;
import io.confluent.connect.s3.storage.IORecordWriter;
import io.confluent.connect.s3.storage.S3OutputStream;
import io.confluent.connect.s3.storage.S3Storage;
import io.confluent.connect.s3.util.Utils;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.connect.converters.ByteArrayConverter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayRecordWriterProvider
extends RecordViewSetter
implements RecordWriterProvider<S3SinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(ByteArrayRecordWriterProvider.class);
    private final S3Storage storage;
    private final ByteArrayConverter converter;
    private final String extension;
    private final byte[] lineSeparatorBytes;

    ByteArrayRecordWriterProvider(S3Storage storage, ByteArrayConverter converter) {
        this.storage = storage;
        this.converter = converter;
        this.extension = storage.conf().getByteArrayExtension();
        this.lineSeparatorBytes = storage.conf().getFormatByteArrayLineSeparator().getBytes(StandardCharsets.UTF_8);
    }

    public String getExtension() {
        return this.extension + this.storage.conf().getCompressionType().extension;
    }

    public RecordWriter getRecordWriter(S3SinkConnectorConfig conf, final String filename) {
        return new S3RetriableRecordWriter(new IORecordWriter(){
            final String adjustedFilename;
            final S3OutputStream s3out;
            final OutputStream s3outWrapper;
            {
                this.adjustedFilename = Utils.getAdjustedFilename(ByteArrayRecordWriterProvider.this.recordView, filename, ByteArrayRecordWriterProvider.this.getExtension());
                this.s3out = ByteArrayRecordWriterProvider.this.storage.create(this.adjustedFilename, true, ByteArrayFormat.class);
                this.s3outWrapper = this.s3out.wrapForCompression();
            }

            @Override
            public void write(SinkRecord record) throws IOException {
                log.trace("Sink record with view {}: {}", (Object)ByteArrayRecordWriterProvider.this.recordView, (Object)Utils.sinkRecordToLoggableString(record));
                byte[] bytes = ByteArrayRecordWriterProvider.this.converter.fromConnectData(record.topic(), ByteArrayRecordWriterProvider.this.recordView.getViewSchema(record, false), ByteArrayRecordWriterProvider.this.recordView.getView(record, false));
                this.s3outWrapper.write(bytes);
                this.s3outWrapper.write(ByteArrayRecordWriterProvider.this.lineSeparatorBytes);
            }

            @Override
            public void commit() throws IOException {
                this.s3out.commit();
                this.s3outWrapper.close();
            }

            @Override
            public void close() throws IOException {
            }
        });
    }
}

