/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3;

import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.S3SinkConnectorValidator;
import io.confluent.connect.s3.S3SinkTask;
import io.confluent.connect.s3.util.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.sink.SinkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3SinkConnector
extends SinkConnector {
    private static final Logger log = LoggerFactory.getLogger(S3SinkConnector.class);
    private Map<String, String> configProps;
    private S3SinkConnectorConfig config;

    public S3SinkConnector() {
    }

    S3SinkConnector(S3SinkConnectorConfig config) {
        this.config = config;
    }

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> props) {
        this.configProps = new HashMap<String, String>(props);
        this.config = new S3SinkConnectorConfig(props);
        log.info("Starting S3 connector {}", (Object)this.config.getName());
    }

    public Class<? extends Task> taskClass() {
        return S3SinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        HashMap<String, String> taskProps = new HashMap<String, String>(this.configProps);
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>(maxTasks);
        for (int i = 0; i < maxTasks; ++i) {
            taskConfigs.add(taskProps);
        }
        return taskConfigs;
    }

    public void stop() {
        log.info("Shutting down S3 connector {}", (Object)this.config.getName());
    }

    public ConfigDef config() {
        return S3SinkConnectorConfig.getConfig();
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Config configs = super.validate(connectorConfigs);
        return new S3SinkConnectorValidator(this.config(), connectorConfigs, configs.configValues()).validate();
    }
}

