/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging;

import io.confluent.common.logging.LogRecordBuilder;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;

public final class LogRecordStructBuilder
implements LogRecordBuilder<Struct> {
    private String level = null;
    private Long timeMs = null;
    private String loggerName = null;
    private SchemaAndValue messageWithSchema = null;

    public LogRecordStructBuilder withLevel(String level) {
        this.level = level;
        return this;
    }

    public LogRecordStructBuilder withTimeMs(long timeMs) {
        this.timeMs = timeMs;
        return this;
    }

    public LogRecordStructBuilder withLoggerName(String loggerName) {
        this.loggerName = loggerName;
        return this;
    }

    public LogRecordStructBuilder withMessageSchemaAndValue(SchemaAndValue messageWithSchema) {
        this.messageWithSchema = messageWithSchema;
        return this;
    }

    @Override
    public LogRecordBuilder<Struct> withMessageJson(String message) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Struct build() {
        Schema logRecordSchema = LogRecordBuilder.baseSchemaBuilder().field("message", this.messageWithSchema.schema()).build();
        Struct logRecord = new Struct(logRecordSchema);
        logRecord.put("logger", (Object)this.loggerName);
        logRecord.put("level", (Object)this.level);
        logRecord.put("time", (Object)this.timeMs);
        logRecord.put("message", this.messageWithSchema.value());
        return logRecord;
    }
}

