/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.provider.InvalidScopeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Scope {
    public static final Scope ROOT_SCOPE = new Scope(Collections.emptyList(), Collections.emptyMap());
    public static final String KAFKA_CLUSTER_TYPE = "kafka-cluster";
    private final Scope parent;
    private final List<String> path;
    private final Map<String, String> clusters;

    @JsonCreator
    public Scope(@JsonProperty(value="path") List<String> path, @JsonProperty(value="clusters") Map<String, String> clusters) {
        this.path = path == null ? Collections.emptyList() : new ArrayList<String>(path);
        HashMap<String, String> hashMap = this.clusters = clusters == null ? Collections.emptyMap() : new HashMap<String, String>(clusters);
        this.parent = !this.clusters.isEmpty() ? new Scope(this.path, Collections.emptyMap()) : (!this.path.isEmpty() ? new Scope(this.path.subList(0, this.path.size() - 1), Collections.emptyMap()) : null);
    }

    @JsonProperty
    public List<String> path() {
        return this.path;
    }

    @JsonProperty
    public Map<String, String> clusters() {
        return this.clusters;
    }

    public Scope parent() {
        return this.parent;
    }

    public void validate(boolean concreteScope) {
        if (concreteScope && this.clusters.isEmpty()) {
            throw new InvalidScopeException("Expected concrete scope with clusters, but not clusters provided");
        }
        this.clusters.forEach((k, v) -> {
            if (k == null || k.isEmpty()) {
                throw new InvalidScopeException("Empty cluster type for cluster id " + v);
            }
            if (v == null || v.isEmpty()) {
                throw new InvalidScopeException("Empty cluster id for cluster type " + k);
            }
        });
        this.path.forEach(p -> {
            if (p == null || p.isEmpty()) {
                throw new InvalidScopeException("Empty scope path entry");
            }
        });
    }

    public boolean containsScope(Scope o) {
        if (o == null) {
            return false;
        }
        if (this.equals(o)) {
            return true;
        }
        return this.containsScope(o.parent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope that = (Scope)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.clusters, that.clusters);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.clusters);
    }

    public String toString() {
        return "Scope(path='" + this.path + '\'' + ", clusters='" + this.clusters + '\'' + ')';
    }

    public static Scope kafkaClusterScope(String kafkaClusterId) {
        return new Builder(new String[0]).withCluster(KAFKA_CLUSTER_TYPE, kafkaClusterId).build();
    }

    public static Scope intermediateScope(String ... scopeEntries) {
        return new Builder(Arrays.asList(scopeEntries)).build();
    }

    public static class Builder {
        private final List<String> path;
        private final Map<String, String> clusters;

        public Builder(String ... path) {
            this(Arrays.asList(path));
        }

        public Builder(List<String> path) {
            this.path = new ArrayList<String>(path);
            this.clusters = new HashMap<String, String>();
        }

        public Builder withKafkaCluster(String clusterId) {
            return this.withCluster(Scope.KAFKA_CLUSTER_TYPE, clusterId);
        }

        public Builder withCluster(String clusterType, String clusterId) {
            if (this.clusters.putIfAbsent(Objects.requireNonNull(clusterType, "clusterType"), Objects.requireNonNull(clusterId, "clusterId")) != null) {
                throw new IllegalArgumentException("Cluster already present in scope: " + clusterType);
            }
            return this;
        }

        public Scope build() {
            return new Scope(this.path, this.clusters);
        }

        public void addPath(String name) {
            this.path.add(name);
        }
    }
}

