/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.response.ProcessInstanceResult;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Map;

public final class CreateProcessInstanceWithResultResponseImpl
implements ProcessInstanceResult {
    private final JsonMapper jsonMapper;
    private final long processDefinitionKey;
    private final String bpmnProcessId;
    private final int version;
    private final long processInstanceKey;
    private final String tenantId;
    private final String variables;
    private Map<String, Object> variablesAsMap;

    public CreateProcessInstanceWithResultResponseImpl(JsonMapper jsonMapper, GatewayOuterClass.CreateProcessInstanceWithResultResponse response) {
        this.jsonMapper = jsonMapper;
        this.processDefinitionKey = response.getProcessDefinitionKey();
        this.bpmnProcessId = response.getBpmnProcessId();
        this.version = response.getVersion();
        this.processInstanceKey = response.getProcessInstanceKey();
        this.variables = response.getVariables();
        this.tenantId = response.getTenantId();
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, Object> getVariablesAsMap() {
        if (this.variablesAsMap == null) {
            this.variablesAsMap = this.jsonMapper.fromJsonAsMap(this.variables);
        }
        return this.variablesAsMap;
    }

    @Override
    public <T> T getVariablesAsType(Class<T> variableType) {
        return this.jsonMapper.fromJson(this.variables, variableType);
    }

    @Override
    public Object getVariable(String name) {
        Map<String, Object> variables = this.getVariablesAsMap();
        if (!variables.containsKey(name)) {
            throw new ClientException(String.format("The variable %s is not available", name));
        }
        return this.getVariablesAsMap().get(name);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public String toString() {
        return "CreateProcessInstanceWithResultResponseImpl{processDefinitionKey=" + this.processDefinitionKey + ", bpmnProcessId='" + this.bpmnProcessId + '\'' + ", version=" + this.version + ", processInstanceKey=" + this.processInstanceKey + ", variables='" + this.variables + '\'' + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

