/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.shiro.realm;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.di.Injector;
import io.bootique.shiro.realm.RealmFactory;
import java.util.Map;
import org.apache.shiro.config.Ini;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;

@BQConfig(value="Creates a Realm from user accounts and roles specified in configuration.")
@JsonTypeName(value="ini")
public class IniRealmFactory
extends RealmFactory {
    private Map<String, String> users;
    private Map<String, String> roles;

    @BQConfigProperty(value="A map of user account names to user password and roles. The values should be in the format used by the [users] section of a Shiro .ini file. Namely 'password, roleName1, roleName2, \u2026, roleNameN'.")
    public void setUsers(Map<String, String> users) {
        this.users = users;
    }

    @BQConfigProperty(value="A map of role names to role permissions. The values should be in the format used by the [roles] section of a Shiro .ini file. Namely 'permissionDefinition1, permissionDefinition2, ..., permissionDefinitionN'.")
    public void setRoles(Map<String, String> roles) {
        this.roles = roles;
    }

    @Override
    public Realm createRealm(Injector injector) {
        Ini ini = new Ini();
        if (this.users != null && !this.users.isEmpty()) {
            ini.addSection("users").putAll(this.users);
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            ini.addSection("roles").putAll(this.roles);
        }
        IniRealm realm = new IniRealm(ini);
        realm.setIni(ini);
        if (this.name != null) {
            realm.setName(this.name);
        }
        return realm;
    }
}

