/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.shiro.realm;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.di.Injector;
import io.bootique.shiro.realm.RealmFactory;
import java.util.Map;
import java.util.Objects;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.activedirectory.ActiveDirectoryRealm;

@BQConfig(value="Creates a Realm that connects to MS ActiveDirectory.")
@JsonTypeName(value="activeDirectory")
public class ActiveDirectoryRealmFactory
extends RealmFactory {
    private String url;
    private String searchBase;
    private String searchFilter;
    private String systemUserName;
    private String systemPassword;
    private Map<String, String> groupsToRoles;

    @BQConfigProperty
    public void setUrl(String url) {
        this.url = url;
    }

    @BQConfigProperty(value="A map of AD group names (e.g. 'CN=Group,OU=Company,DC=MyDomain,DC=local') to Shiro roles.")
    public void setGroupsToRoles(Map<String, String> groupsToRoles) {
        this.groupsToRoles = groupsToRoles;
    }

    @BQConfigProperty
    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    @BQConfigProperty
    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    @BQConfigProperty
    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    @BQConfigProperty
    public void setSystemUserName(String systemUserName) {
        this.systemUserName = systemUserName;
    }

    @Override
    public Realm createRealm(Injector injector) {
        ActiveDirectoryRealm realm = new ActiveDirectoryRealm();
        if (this.name != null) {
            realm.setName(this.name);
        }
        realm.setUrl(Objects.requireNonNull(this.url, "'url' property is required"));
        if (this.groupsToRoles != null) {
            realm.setGroupRolesMap(this.groupsToRoles);
        }
        if (this.searchBase != null) {
            realm.setSearchBase(this.searchBase);
        }
        if (this.searchFilter != null) {
            realm.setSearchFilter(this.searchFilter);
        }
        if (this.systemPassword != null) {
            realm.setSystemPassword(this.systemPassword);
        }
        if (this.systemUserName != null) {
            realm.setSystemUsername(this.systemUserName);
        }
        return realm;
    }
}

