/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.shiro;

import io.bootique.ModuleExtender;
import io.bootique.di.Binder;
import io.bootique.di.SetBuilder;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.realm.Realm;

public class ShiroModuleExtender
extends ModuleExtender<ShiroModuleExtender> {
    private SetBuilder<Realm> realms;
    private SetBuilder<AuthenticationListener> listeners;

    public ShiroModuleExtender(Binder binder) {
        super(binder);
    }

    public ShiroModuleExtender initAllExtensions() {
        this.contributeRealms();
        this.contributeListeners();
        return this;
    }

    public ShiroModuleExtender addAuthListener(AuthenticationListener listener) {
        this.contributeListeners().addInstance((Object)listener);
        return this;
    }

    public ShiroModuleExtender addAuthListener(Class<? extends AuthenticationListener> listenerType) {
        this.contributeListeners().add(listenerType);
        return this;
    }

    public ShiroModuleExtender addRealm(Realm realm) {
        this.contributeRealms().addInstance((Object)realm);
        return this;
    }

    public ShiroModuleExtender addRealm(Class<? extends Realm> realmType) {
        this.contributeRealms().add(realmType);
        return this;
    }

    protected SetBuilder<Realm> contributeRealms() {
        return this.realms != null ? this.realms : (this.realms = this.newSet(Realm.class));
    }

    protected SetBuilder<AuthenticationListener> contributeListeners() {
        return this.listeners != null ? this.listeners : (this.listeners = this.newSet(AuthenticationListener.class));
    }
}

