/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.shiro;

import io.bootique.ConfigModule;
import io.bootique.config.ConfigurationFactory;
import io.bootique.di.Binder;
import io.bootique.di.Injector;
import io.bootique.di.Provides;
import io.bootique.shiro.ShiroConfigurator;
import io.bootique.shiro.ShiroConfiguratorFactory;
import io.bootique.shiro.ShiroModuleExtender;
import io.bootique.shiro.mdc.PrincipalMDC;
import io.bootique.shiro.mgt.NoRememberMeManager;
import java.util.Set;
import javax.inject.Singleton;
import org.apache.shiro.authc.AbstractAuthenticator;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;

public class ShiroModule
extends ConfigModule {
    public static ShiroModuleExtender extend(Binder binder) {
        return new ShiroModuleExtender(binder);
    }

    public void configure(Binder binder) {
        ShiroModule.extend(binder).initAllExtensions();
    }

    @Provides
    @Singleton
    ShiroConfigurator provideRealms(Injector injector, ConfigurationFactory configFactory, Set<Realm> diRealms) {
        return ((ShiroConfiguratorFactory)this.config(ShiroConfiguratorFactory.class, configFactory)).createConfigurator(injector, diRealms);
    }

    @Singleton
    @Provides
    RememberMeManager provideRememberMeManager() {
        return new NoRememberMeManager();
    }

    @Provides
    @Singleton
    SecurityManager provideSecurityManager(SessionManager sessionManager, RememberMeManager rememberMeManager, SubjectDAO subjectDAO, ShiroConfigurator configurator, Set<AuthenticationListener> authListeners) {
        DefaultSecurityManager manager = new DefaultSecurityManager(configurator.getRealms());
        ((AbstractAuthenticator)manager.getAuthenticator()).setAuthenticationListeners(authListeners);
        manager.setSessionManager(sessionManager);
        manager.setRememberMeManager(rememberMeManager);
        manager.setSubjectDAO(subjectDAO);
        return manager;
    }

    @Provides
    @Singleton
    SessionManager provideSessionManager() {
        return new DefaultSessionManager();
    }

    @Provides
    @Singleton
    PrincipalMDC providePrincipalMDC() {
        return new PrincipalMDC();
    }

    @Provides
    @Singleton
    SubjectDAO provideSubjectDAO(SessionStorageEvaluator sessionStorageEvaluator) {
        DefaultSubjectDAO dao = new DefaultSubjectDAO();
        dao.setSessionStorageEvaluator(sessionStorageEvaluator);
        return dao;
    }

    @Provides
    @Singleton
    SessionStorageEvaluator provideSessionStorageEvaluator(ShiroConfigurator configurator) {
        DefaultSessionStorageEvaluator sessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        sessionStorageEvaluator.setSessionStorageEnabled(!configurator.isSessionStorageDisabled());
        return sessionStorageEvaluator;
    }
}

