/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.shiro;

import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.di.Injector;
import io.bootique.shiro.ShiroConfigurator;
import io.bootique.shiro.realm.RealmFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.realm.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BQConfig
public class ShiroConfiguratorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShiroConfiguratorFactory.class);
    private List<RealmFactory> realms;
    private boolean sessionStorageDisabled;

    @BQConfigProperty
    public void setRealms(List<RealmFactory> realms) {
        this.realms = realms;
    }

    @BQConfigProperty(value="Whether to disable Subject session storage, ensuring a session-less app. Default is 'false' to match Shiro defaults")
    public void setSessionStorageDisabled(boolean sessionStorageDisabled) {
        this.sessionStorageDisabled = sessionStorageDisabled;
    }

    public ShiroConfigurator createConfigurator(Injector injector, Set<Realm> diRealms) {
        return new ShiroConfigurator(this.createRealms(injector, diRealms), this.sessionStorageDisabled);
    }

    protected List<Realm> createRealms(Injector injector, Set<Realm> diRealms) {
        ArrayList<Realm> allRealms = new ArrayList<Realm>();
        this.loadConfiguredRealms(allRealms, injector);
        if (allRealms.isEmpty()) {
            this.loadDiRealms(allRealms, diRealms);
        } else if (!diRealms.isEmpty() && LOGGER.isInfoEnabled()) {
            String realmNames = diRealms.stream().map(this::realmName).collect(Collectors.joining(", "));
            LOGGER.info("Ignoring DI-originated Realms: " + realmNames + ". Using Realms from configuration instead.");
        }
        if (allRealms.isEmpty()) {
            LOGGER.warn("No Realms configured for Shiro");
            this.loadPlaceholderRealm(allRealms);
        }
        return allRealms;
    }

    void loadConfiguredRealms(List<Realm> collector, Injector injector) {
        if (this.realms != null) {
            this.realms.forEach(rf -> collector.add(rf.createRealm(injector)));
        }
    }

    void loadDiRealms(List<Realm> collector, Set<Realm> diRealms) {
        collector.addAll(diRealms);
    }

    void loadPlaceholderRealm(List<Realm> collector) {
        collector.add(new Realm(){

            public String getName() {
                return "do_nothing_realm";
            }

            public boolean supports(AuthenticationToken token) {
                throw new UnsupportedTokenException("Realm '" + this.getName() + "' is a placeholder and does not support authentication. You need to configure a real Realm");
            }

            public AuthenticationInfo getAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
                throw new AuthenticationException("This is a placeholder Realm that does not support authentication");
            }
        });
    }

    private String realmName(Realm r) {
        return r.getName() != null ? r.getName() : r.getClass().getSimpleName();
    }
}

