/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.shiro.web.mdc;

import io.bootique.jetty.request.RequestMDCItem;
import io.bootique.shiro.mdc.PrincipalMDC;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.PrincipalCollection;

public class ShiroWebPrincipalMDCItem
implements RequestMDCItem,
AuthenticationListener {
    private final PrincipalMDC principalMDC;

    public ShiroWebPrincipalMDCItem(PrincipalMDC principalMDC) {
        this.principalMDC = Objects.requireNonNull(principalMDC);
    }

    public void initMDC(ServletContext sc, ServletRequest request) {
        this.principalMDC.clear();
    }

    public void cleanupMDC(ServletContext sc, ServletRequest request) {
        this.principalMDC.clear();
    }

    public void onSuccess(AuthenticationToken token, AuthenticationInfo info) {
        Object principal = info.getPrincipals().getPrimaryPrincipal();
        this.principalMDC.reset(principal);
    }

    public void onFailure(AuthenticationToken token, AuthenticationException ae) {
    }

    public void onLogout(PrincipalCollection principals) {
        this.principalMDC.clear();
    }
}

