/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.runtime.process.DataTransformer;
import io.automatiko.engine.workflow.base.core.impl.DataTransformerRegistry;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractNodeHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.ProcessAction;
import io.automatiko.engine.workflow.process.core.impl.ConsequenceAction;
import io.automatiko.engine.workflow.process.core.node.ActionNode;
import io.automatiko.engine.workflow.process.core.node.Assignment;
import io.automatiko.engine.workflow.process.core.node.DataAssociation;
import io.automatiko.engine.workflow.process.core.node.ForEachNode;
import io.automatiko.engine.workflow.process.core.node.Transformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ScriptTaskHandler
extends AbstractNodeHandler {
    private static Map<String, String> SUPPORTED_SCRIPT_FORMATS = new HashMap<String, String>();
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();

    public static void registerSupportedScriptFormat(String language, String dialect) {
        SUPPORTED_SCRIPT_FORMATS.put(language, dialect);
    }

    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        ActionNode result = new ActionNode();
        result.setAction((ProcessAction)new ConsequenceAction());
        return result;
    }

    public Class generateNodeFor() {
        return io.automatiko.engine.workflow.process.core.Node.class;
    }

    @Override
    protected void handleNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        boolean isForCompensation;
        super.handleNode(node, element, uri, localName, parser);
        ActionNode actionNode = (ActionNode)node;
        node.setMetaData("NodeType", (Object)"ScriptTask");
        ConsequenceAction action = (ConsequenceAction)actionNode.getAction();
        if (action == null) {
            action = new ConsequenceAction();
            actionNode.setAction((ProcessAction)action);
        }
        String language = element.getAttribute("scriptFormat");
        action.setDialect(SUPPORTED_SCRIPT_FORMATS.getOrDefault(language, "mvel"));
        action.setConsequence("");
        this.dataInputs.clear();
        this.dataOutputs.clear();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (xmlNode instanceof Element && "script".equals(nodeName)) {
                action.setConsequence(xmlNode.getTextContent());
                continue;
            }
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs, this.dataInputTypes, this.dataOutputTypes);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, actionNode, this.dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, actionNode, this.dataOutputs);
        }
        actionNode.setMetaData("DataInputs", new LinkedHashMap(this.dataInputs));
        actionNode.setMetaData("DataOutputs", new LinkedHashMap(this.dataOutputs));
        String compensation = element.getAttribute("isForCompensation");
        if (compensation != null && (isForCompensation = Boolean.parseBoolean(compensation))) {
            actionNode.setMetaData("isForCompensation", (Object)isForCompensation);
        }
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        io.automatiko.engine.workflow.process.core.Node node = (io.automatiko.engine.workflow.process.core.Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        int uniqueIdGen = 1;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            ForEachNode forEachNode = new ForEachNode();
            forEachNode.setId(node.getId());
            String uniqueId = (String)node.getMetaData().get("UniqueId");
            forEachNode.setMetaData("UniqueId", (Object)uniqueId);
            node.setMetaData("UniqueId", (Object)(uniqueId + ":" + uniqueIdGen++));
            forEachNode.addNode((Node)node);
            forEachNode.linkIncomingConnections("DEFAULT", node.getId(), "DEFAULT");
            forEachNode.linkOutgoingConnections(node.getId(), "DEFAULT", "DEFAULT");
            forEachNode.setSequential(Boolean.parseBoolean(((Element)xmlNode).getAttribute("isSequential")));
            io.automatiko.engine.workflow.process.core.Node orignalNode = node;
            node = forEachNode;
            this.handleForEachNode(node, element, uri, localName, parser);
            if (!(orignalNode instanceof ActionNode)) break;
            this.adjustNodeConfiguration(orignalNode, forEachNode);
            break;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by action node handler");
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, ActionNode actionNode, Map<String, String> dataInputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            ArrayList<String> sources = new ArrayList<String>();
            sources.add(subNode.getTextContent());
            subNode = subNode.getNextSibling();
            while ("sourceRef".equals(subNode.getNodeName())) {
                sources.add(subNode.getTextContent());
                subNode = subNode.getNextSibling();
            }
            String target = subNode.getTextContent();
            Transformation transformation = null;
            if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
                String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
                String expression = subNode.getTextContent();
                DataTransformer transformer = this.transformerRegistry.find(lang);
                if (transformer == null) {
                    throw new IllegalArgumentException("No transformer registered for language " + lang);
                }
                transformation = new Transformation(lang, expression);
                subNode = subNode.getNextSibling();
            }
            LinkedList<Assignment> assignments = new LinkedList<Assignment>();
            while (subNode != null) {
                String expressionLang = ((Element)subNode).getAttribute("expressionLanguage");
                if (expressionLang == null || expressionLang.trim().isEmpty()) {
                    expressionLang = "XPath";
                }
                org.w3c.dom.Node ssubNode = subNode.getFirstChild();
                String from = ssubNode.getTextContent();
                String to = ssubNode.getNextSibling().getTextContent();
                assignments.add(new Assignment(expressionLang, from, to));
                subNode = subNode.getNextSibling();
            }
            actionNode.addInAssociation(new DataAssociation(sources, dataInputs.get(target), assignments, transformation));
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, ActionNode actionNode, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(subNode.getTextContent());
        subNode = subNode.getNextSibling();
        while ("sourceRef".equals(subNode.getNodeName())) {
            sources.add(subNode.getTextContent());
            subNode = subNode.getNextSibling();
        }
        String target = subNode.getTextContent();
        Transformation transformation = null;
        if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
            String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
            String expression = subNode.getTextContent();
            DataTransformer transformer = this.transformerRegistry.find(lang);
            if (transformer == null) {
                throw new IllegalArgumentException("No transformer registered for language " + lang);
            }
            transformation = new Transformation(lang, expression);
            subNode = subNode.getNextSibling();
        }
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        while (subNode != null) {
            String expressionLang = ((Element)subNode).getAttribute("expressionLanguage");
            if (expressionLang == null || expressionLang.trim().isEmpty()) {
                expressionLang = "XPath";
            }
            org.w3c.dom.Node ssubNode = subNode.getFirstChild();
            String from = ssubNode.getTextContent();
            String to = ssubNode.getNextSibling().getTextContent();
            assignments.add(new Assignment(expressionLang, from, to));
            subNode = subNode.getNextSibling();
        }
        actionNode.addOutAssociation(new DataAssociation(sources.stream().map(source -> (String)dataOutputs.get(source)).collect(Collectors.toList()), target, assignments, transformation));
    }

    protected void adjustNodeConfiguration(io.automatiko.engine.workflow.process.core.Node orignalNode, ForEachNode forEachNode) {
        List inputs = ((ActionNode)orignalNode).adjustInMapping(forEachNode.getCollectionExpression());
        List outputs = ((ActionNode)orignalNode).adjustOutMapping(forEachNode.getOutputCollectionExpression());
        if (inputs != null) {
            forEachNode.addInAssociation(inputs);
        }
        if (outputs != null) {
            forEachNode.addOutAssociation(outputs);
        }
    }

    protected void handleForEachNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) {
        ForEachNode forEachNode = (ForEachNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, this.inputAssociation);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, this.outputAssociation);
                continue;
            }
            if (!"multiInstanceLoopCharacteristics".equals(nodeName)) continue;
            this.readMultiInstanceLoopCharacteristics(xmlNode, forEachNode, parser);
        }
    }

    static {
        SUPPORTED_SCRIPT_FORMATS.put("http://www.java.com/java", "java");
        SUPPORTED_SCRIPT_FORMATS.put("http://www.javascript.com/javascript", "JavaScript");
        SUPPORTED_SCRIPT_FORMATS.put("http://www.omg.org/spec/FEEL/20140401", "FEEL");
        SUPPORTED_SCRIPT_FORMATS.put("application/feel", "FEEL");
    }
}

