/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Node;
import io.automatiko.engine.api.runtime.process.DataTransformer;
import io.automatiko.engine.workflow.base.core.event.EventTransformer;
import io.automatiko.engine.workflow.base.core.event.EventTransformerImpl;
import io.automatiko.engine.workflow.base.core.event.EventTypeFilter;
import io.automatiko.engine.workflow.base.core.impl.DataTransformerRegistry;
import io.automatiko.engine.workflow.base.core.timer.Timer;
import io.automatiko.engine.workflow.bpmn2.core.IntermediateLink;
import io.automatiko.engine.workflow.bpmn2.core.ItemDefinition;
import io.automatiko.engine.workflow.bpmn2.core.Message;
import io.automatiko.engine.workflow.bpmn2.core.Signal;
import io.automatiko.engine.workflow.bpmn2.xml.AbstractNodeHandler;
import io.automatiko.engine.workflow.bpmn2.xml.MalformedNodeException;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.ProcessBuildData;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.node.CatchLinkNode;
import io.automatiko.engine.workflow.process.core.node.CompositeNode;
import io.automatiko.engine.workflow.process.core.node.EventNode;
import io.automatiko.engine.workflow.process.core.node.StateNode;
import io.automatiko.engine.workflow.process.core.node.TimerNode;
import io.automatiko.engine.workflow.process.core.node.Transformation;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IntermediateCatchEventHandler
extends AbstractNodeHandler {
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();
    public static final String LINK_NAME = "LinkName";

    @Override
    protected io.automatiko.engine.workflow.process.core.Node createNode(Attributes attrs) {
        return new EventNode();
    }

    public Class generateNodeFor() {
        return EventNode.class;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        io.automatiko.engine.workflow.process.core.Node node = (io.automatiko.engine.workflow.process.core.Node)parser.getCurrent();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("signalEventDefinition".equals(nodeName)) {
                this.handleSignalNode(node, element, uri, localName, parser);
                node.setMetaData("EventType", (Object)"signal");
                node.setMetaData("functionFlowContinue", (Object)"true");
                break;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                this.handleMessageNode(node, element, uri, localName, parser);
                node.setMetaData("EventType", (Object)"message");
                node.setMetaData("functionFlowContinue", (Object)"true");
                break;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                TimerNode timerNode = new TimerNode();
                timerNode.setId(node.getId());
                timerNode.setName(node.getName());
                timerNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = timerNode;
                node.setMetaData("EventType", (Object)"timer");
                this.handleTimerNode(node, element, uri, localName, parser);
                node.setMetaData("functionFlowContinue", (Object)"true");
                break;
            }
            if ("conditionalEventDefinition".equals(nodeName)) {
                StateNode stateNode = new StateNode();
                stateNode.setId(node.getId());
                stateNode.setName(node.getName());
                stateNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = stateNode;
                node.setMetaData("EventType", (Object)"conditional");
                this.handleStateNode(node, element, uri, localName, parser);
                node.setMetaData("functionFlowContinue", (Object)"true");
                break;
            }
            if (!"linkEventDefinition".equals(nodeName)) continue;
            CatchLinkNode linkNode = new CatchLinkNode();
            linkNode.setId(node.getId());
            node = linkNode;
            node.setMetaData("EventType", (Object)"link");
            this.handleLinkNode(element, node, xmlNode, parser);
            break;
        }
        node.setMetaData("DataOutputs", new LinkedHashMap(this.dataOutputTypes));
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected void handleLinkNode(Element element, io.automatiko.engine.workflow.process.core.Node node, org.w3c.dom.Node xmlLinkNode, ExtensibleXmlParser parser) {
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        node.setName(element.getAttribute("name"));
        NamedNodeMap linkAttr = xmlLinkNode.getAttributes();
        String name = linkAttr.getNamedItem("name").getNodeValue();
        String id = element.getAttribute("id");
        node.setMetaData("UniqueId", (Object)id);
        node.setMetaData(LINK_NAME, (Object)name);
        IntermediateLink aLink = new IntermediateLink();
        aLink.setName(name);
        aLink.setUniqueId(id);
        for (org.w3c.dom.Node xmlNode = xmlLinkNode.getFirstChild(); null != xmlNode; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("target".equals(nodeName)) {
                String target = xmlNode.getTextContent();
                node.setMetaData("target", (Object)target);
                aLink.setTarget(target);
            }
            if (!"source".equals(nodeName)) continue;
            String source = xmlNode.getTextContent();
            node.setMetaData("source", (Object)source);
            aLink.addSource(source);
        }
        if (nodeContainer instanceof ExecutableProcess) {
            ExecutableProcess process = (ExecutableProcess)nodeContainer;
            links = (ArrayList<IntermediateLink>)process.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList<IntermediateLink>();
            }
            links.add(aLink);
            process.setMetaData("BPMN.ThrowLinks", links);
        } else if (nodeContainer instanceof CompositeNode) {
            CompositeNode subprocess = (CompositeNode)nodeContainer;
            links = (List)subprocess.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList();
            }
            links.add(aLink);
            subprocess.setMetaData("BPMN.ThrowLinks", links);
        }
    }

    protected void handleSignalNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String type;
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                this.populateDataOutputs(xmlNode, outputName, parser);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, eventNode);
                continue;
            }
            if (!"signalEventDefinition".equals(nodeName) || (type = ((Element)xmlNode).getAttribute("signalRef")) == null || type.trim().length() <= 0) continue;
            Signal signal = this.findSignalByName(parser, type);
            if (signal != null) {
                eventNode.setMetaData("MessageType", (Object)this.retrieveDataType(signal.getStructureRef(), null, parser));
            }
            type = this.checkSignalAndConvertToRealSignalNam(parser, type);
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType(type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
        }
    }

    protected void handleMessageNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            String id = ((Element)xmlNode).getAttribute("id");
            String name = ((Element)xmlNode).getAttribute("name");
            if ("dataOutput".equals(nodeName)) {
                this.dataOutputs.put(id, name);
                this.populateDataOutputs(xmlNode, name, parser);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, eventNode);
                continue;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new IllegalArgumentException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new MalformedNodeException(id, name, MessageFormat.format("Could not find message \"{0}\"", messageRef));
            }
            eventNode.setMetaData("MessageType", (Object)message.getType());
            eventNode.setMetaData("TriggerType", (Object)"ConsumeMessage");
            eventNode.setMetaData("TriggerRef", (Object)message.getName());
            eventNode.setMetaData("TriggerCorrelation", (Object)message.getCorrelation());
            eventNode.setMetaData("TriggerCorrelationExpr", (Object)message.getCorrelationExpression());
            for (Map.Entry<String, Object> entry : message.getMetaData().entrySet()) {
                eventNode.setMetaData(entry.getKey(), entry.getValue());
            }
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Message-" + message.getName());
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
        }
    }

    protected void handleTimerNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        TimerNode timerNode = (TimerNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            Timer timer = new Timer();
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String delay;
                String subNodeName = subNode.getNodeName();
                if ("timeCycle".equals(subNodeName)) {
                    delay = subNode.getTextContent();
                    int index = delay.indexOf("###");
                    if (index != -1) {
                        String period = delay.substring(index + 3);
                        delay = delay.substring(0, index);
                        timer.setPeriod(period);
                    }
                    timer.setTimeType(2);
                    timer.setDelay(delay);
                    break;
                }
                if ("timeDuration".equals(subNodeName)) {
                    delay = subNode.getTextContent();
                    timer.setTimeType(1);
                    timer.setDelay(delay);
                    break;
                }
                if ("timeDate".equals(subNodeName)) {
                    String date = subNode.getTextContent();
                    timer.setTimeType(3);
                    timer.setDate(date);
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            timerNode.setTimer(timer);
        }
    }

    protected void handleStateNode(io.automatiko.engine.workflow.process.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StateNode stateNode = (StateNode)node;
        block0: for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"conditionalEventDefinition".equals(nodeName)) continue;
            for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                String subnodeName = subNode.getNodeName();
                if (!"condition".equals(subnodeName)) continue;
                String condition = xmlNode.getTextContent();
                stateNode.setMetaData("Condition", (Object)condition);
                continue block0;
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, EventNode eventNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String from = subNode.getTextContent();
        String to = null;
        Transformation transformation = null;
        if ((subNode = subNode.getNextSibling()) != null && "targetRef".equals(subNode.getNodeName())) {
            to = subNode.getTextContent();
            eventNode.setVariableName(to);
            subNode = subNode.getNextSibling();
        }
        if (subNode != null && "transformation".equals(subNode.getNodeName())) {
            String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
            String expression = subNode.getTextContent();
            DataTransformer transformer = this.transformerRegistry.find(lang);
            if (transformer == null) {
                throw new IllegalArgumentException("No transformer registered for language " + lang);
            }
            transformation = new Transformation(lang, expression, (String)this.dataOutputs.get(from));
            eventNode.setMetaData("Transformation", (Object)transformation);
            eventNode.setEventTransformer((EventTransformer)new EventTransformerImpl(transformation));
        } else if (subNode != null && "assignment".equals(subNode.getNodeName())) {
            while (subNode != null) {
                org.w3c.dom.Node ssubNode = subNode.getFirstChild();
                to = ssubNode.getNextSibling().getTextContent();
                subNode = subNode.getNextSibling();
                eventNode.setVariableName(to);
            }
        }
    }

    protected void populateDataOutputs(org.w3c.dom.Node xmlNode, String outputName, ExtensibleXmlParser parser) {
        Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        String itemSubjectRef = ((Element)xmlNode).getAttribute("itemSubjectRef");
        if (itemSubjectRef == null || itemSubjectRef.isEmpty()) {
            String dataType = ((Element)xmlNode).getAttribute("dtype");
            if (dataType == null || dataType.isEmpty()) {
                dataType = "java.lang.String";
            }
            this.dataOutputTypes.put(outputName, dataType);
        } else if (itemDefinitions.get(itemSubjectRef) != null) {
            this.dataOutputTypes.put(outputName, ((ItemDefinition)itemDefinitions.get(itemSubjectRef)).getStructureRef());
        } else {
            this.dataOutputTypes.put(outputName, "java.lang.Object");
        }
    }

    @Override
    public void writeNode(io.automatiko.engine.workflow.process.core.Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

