/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.workflow.bpmn2.xml;

import io.automatiko.engine.api.definition.process.Process;
import io.automatiko.engine.workflow.base.core.context.variable.Variable;
import io.automatiko.engine.workflow.bpmn2.core.Association;
import io.automatiko.engine.workflow.bpmn2.core.Lane;
import io.automatiko.engine.workflow.bpmn2.core.SequenceFlow;
import io.automatiko.engine.workflow.compiler.xml.BaseAbstractHandler;
import io.automatiko.engine.workflow.compiler.xml.ExtensibleXmlParser;
import io.automatiko.engine.workflow.compiler.xml.Handler;
import io.automatiko.engine.workflow.process.core.Node;
import io.automatiko.engine.workflow.process.core.NodeContainer;
import io.automatiko.engine.workflow.process.core.node.CompositeContextNode;
import io.automatiko.engine.workflow.process.core.node.CompositeNode;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AssociationHandler
extends BaseAbstractHandler
implements Handler {
    public AssociationHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Process.class);
            this.validParents.add(CompositeContextNode.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(Lane.class);
            this.validPeers.add(Variable.class);
            this.validPeers.add(Node.class);
            this.validPeers.add(SequenceFlow.class);
            this.validPeers.add(Lane.class);
            this.validPeers.add(Association.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        Association association = new Association();
        association.setId(attrs.getValue("id"));
        association.setSourceRef(attrs.getValue("sourceRef"));
        association.setTargetRef(attrs.getValue("targetRef"));
        String direction = attrs.getValue("associationDirection");
        if (direction != null) {
            String[] possibleDirections;
            boolean acceptableDirection = false;
            direction = direction.toLowerCase();
            for (String acceptable : possibleDirections = new String[]{"none", "one", "both"}) {
                if (!acceptable.equals(direction)) continue;
                acceptableDirection = true;
                break;
            }
            if (!acceptableDirection) {
                throw new IllegalArgumentException("Unknown direction '" + direction + "' used in Association " + association.getId());
            }
        }
        association.setDirection(direction);
        List<Association> associations = null;
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        if (nodeContainer instanceof Process) {
            ExecutableProcess process = (ExecutableProcess)nodeContainer;
            associations = (List)process.getMetaData("BPMN.Associations");
            if (associations == null) {
                associations = new ArrayList();
                process.setMetaData("BPMN.Associations", associations);
            }
        } else if (nodeContainer instanceof CompositeNode) {
            CompositeContextNode compositeNode = (CompositeContextNode)nodeContainer;
            associations = (List)compositeNode.getMetaData("BPMN.Associations");
            if (associations == null) {
                associations = new ArrayList();
                compositeNode.setMetaData("BPMN.Associations", associations);
            }
        } else {
            associations = new ArrayList();
        }
        associations.add(association);
        return association;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        return parser.getCurrent();
    }

    public Class<?> generateNodeFor() {
        return Association.class;
    }
}

