/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.usertasks.notification.webhook;

import io.automatiko.engine.addons.usertasks.notification.NotificationEmitter;
import io.automatiko.engine.api.definition.process.Process;
import io.automatiko.engine.api.runtime.process.HumanTaskWorkItem;
import io.automatiko.engine.api.runtime.process.NodeInstance;
import io.automatiko.engine.api.runtime.process.WorkItem;
import io.automatiko.engine.workflow.base.instance.impl.util.VariableUtil;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Template;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebHookNotificationEmitter<T>
implements NotificationEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebHookNotificationEmitter.class);
    private Map<String, T> webHooks = new ConcurrentHashMap<String, T>();
    private Map<String, String> connections = new ConcurrentHashMap<String, String>();
    private Engine engine;
    private String serviceUrl;

    public WebHookNotificationEmitter() {
    }

    public WebHookNotificationEmitter(Engine engine, Optional<String> serviceUrl) {
        this.engine = engine;
        this.serviceUrl = serviceUrl.orElse("http://localhost:8080");
    }

    protected abstract String defaultTemplate();

    protected abstract String templateSuffix();

    protected String buildTemplate(Map<String, Object> data, WorkItem workItem) {
        HumanTaskWorkItem humanTask = (HumanTaskWorkItem)workItem;
        Template template = this.getTemplate(humanTask.getProcessInstance().getProcess(), humanTask);
        if (template == null) {
            template = this.engine.getTemplate(this.defaultTemplate());
        }
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("name", humanTask.getTaskName());
        templateData.put("description", humanTask.getTaskDescription());
        templateData.put("taskId", humanTask.getId());
        templateData.put("instanceId", humanTask.getProcessInstanceId());
        templateData.put("processId", humanTask.getProcessInstance().getProcessId());
        templateData.put("processName", humanTask.getProcessInstance().getProcessName());
        templateData.put("inputs", humanTask.getParameters());
        Object parentProcessInstanceId = humanTask.getProcessInstance().getParentProcessInstanceId();
        parentProcessInstanceId = parentProcessInstanceId != null && !((String)parentProcessInstanceId).isEmpty() ? (String)parentProcessInstanceId + ":" : "";
        String version = this.version(humanTask.getProcessInstance().getProcess().getVersion());
        String encoded = Base64.getEncoder().encodeToString((humanTask.getProcessInstance().getProcessId() + version + "|" + (String)parentProcessInstanceId + humanTask.getProcessInstance().getId() + "|" + humanTask.getId()).getBytes(StandardCharsets.UTF_8));
        String link = this.serviceUrl + "/management/tasks/link/" + encoded;
        templateData.put("link", link);
        return template.instance().data(templateData).render();
    }

    protected T webhook(String channel, String configProperty) {
        String urlForChannel = this.connections.computeIfAbsent(channel, k -> ConfigProvider.getConfig().getOptionalValue(configProperty + channel, String.class).orElse(null));
        if (urlForChannel == null) {
            return null;
        }
        return (T)this.webHooks.computeIfAbsent(channel, k -> this.buildConnector(urlForChannel));
    }

    protected Template getTemplate(Process process, HumanTaskWorkItem humanTask) {
        Template template = this.engine.getTemplate(process.getId() + this.version(process.getVersion()) + "." + humanTask.getParameters().getOrDefault("TaskName", humanTask.getTaskName()) + this.templateSuffix());
        if (template == null) {
            template = this.engine.getTemplate(humanTask.getParameters().getOrDefault("TaskName", humanTask.getTaskName()) + this.templateSuffix());
        }
        return template;
    }

    protected String version(String version) {
        if (version != null && !version.trim().isEmpty()) {
            return "_" + version.replaceAll("\\.", "_");
        }
        return "";
    }

    protected abstract T buildConnector(String var1);

    protected String getMetadataValue(String name, WorkItem workItem) {
        String value = (String)workItem.getNodeInstance().getNode().getMetaData().get(name);
        LOGGER.debug("Value (orig) from metadata '{}'", (Object)value);
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        value = VariableUtil.resolveVariable((String)value, (NodeInstance)workItem.getNodeInstance());
        LOGGER.debug("Value (resolved) from metadata '{}'", (Object)value);
        return value;
    }
}

