/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.util;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializationException;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.util.reference.ReferenceCounted;
import io.atomix.catalyst.util.reference.ReferenceFactory;
import io.atomix.catalyst.util.reference.ReferenceManager;
import io.atomix.catalyst.util.reference.ReferencePool;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class CatalystSerializableSerializer<T extends CatalystSerializable>
implements TypeSerializer<T> {
    private final Map<Class<?>, ReferencePool<?>> pools = new HashMap();
    private final Map<Class<?>, Constructor<?>> constructorMap = new HashMap();

    @Override
    public void write(T object, BufferOutput buffer, Serializer serializer) {
        object.writeObject(buffer, serializer);
    }

    @Override
    public T read(Class<T> type, BufferInput buffer, Serializer serializer) {
        if (ReferenceCounted.class.isAssignableFrom(type)) {
            return this.readReference(type, buffer, serializer);
        }
        return this.readObject(type, buffer, serializer);
    }

    private T readReference(Class<T> type, BufferInput<?> buffer, Serializer serializer) {
        ReferencePool pool = this.pools.get(type);
        if (pool == null) {
            Constructor<Object> constructor = this.constructorMap.get(type);
            if (constructor == null) {
                try {
                    constructor = type.getDeclaredConstructor(ReferenceManager.class);
                    constructor.setAccessible(true);
                    this.constructorMap.put(type, constructor);
                }
                catch (NoSuchMethodException e) {
                    throw new SerializationException("failed to instantiate reference: must provide a single argument constructor", e);
                }
            }
            pool = new ReferencePool(this.createFactory(constructor));
            this.pools.put(type, pool);
        }
        CatalystSerializable object = (CatalystSerializable)pool.acquire();
        object.readObject(buffer, serializer);
        return (T)object;
    }

    private ReferenceFactory<?> createFactory(Constructor<?> constructor) {
        return manager -> {
            try {
                return (ReferenceCounted)constructor.newInstance(manager);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new SerializationException("failed to instantiate reference", e);
            }
        };
    }

    private T readObject(Class<T> type, BufferInput<?> buffer, Serializer serializer) {
        try {
            Constructor<Object> constructor = this.constructorMap.get(type);
            if (constructor == null) {
                try {
                    constructor = type.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    this.constructorMap.put(type, constructor);
                }
                catch (NoSuchMethodException e) {
                    throw new SerializationException("failed to instantiate reference: must provide a single argument constructor", e);
                }
            }
            CatalystSerializable object = (CatalystSerializable)constructor.newInstance(new Object[0]);
            object.readObject(buffer, serializer);
            return (T)object;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new SerializationException("failed to instantiate object: must provide a no argument constructor", e);
        }
    }
}

