/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.request;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.Request;
import io.apptik.comm.jus.converter.GsonRequestConverter;
import io.apptik.comm.jus.converter.GsonResponseConverter;
import io.apptik.comm.jus.http.HttpUrl;
import java.io.IOException;

public class GsonRequest<T>
extends Request<T> {
    public GsonRequest(String method, HttpUrl url, TypeAdapter<T> typeAdapter) {
        super(method, url, new GsonResponseConverter<T>(typeAdapter));
    }

    public GsonRequest(String method, HttpUrl url, Class<T> tClass, Gson gson) {
        this(method, url, gson.getAdapter(tClass));
    }

    public GsonRequest(String method, HttpUrl url, Class<T> tClass) {
        this(method, url, tClass, new Gson());
    }

    public GsonRequest(String method, String url, TypeAdapter<T> typeAdapter) {
        super(method, url, new GsonResponseConverter<T>(typeAdapter));
    }

    public GsonRequest(String method, String url, Class<T> tClass, Gson gson) {
        this(method, url, gson.getAdapter(tClass));
    }

    public GsonRequest(String method, String url, Class<T> tClass) {
        this(method, url, tClass, new Gson());
    }

    public <R> Request<T> setRequestData(R requestData, Gson gson, TypeAdapter<R> adapter) {
        try {
            super.setRequestData(requestData, new GsonRequestConverter<R>(gson, adapter));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert " + requestData + " to NetworkRequest", e);
        }
        this.setNetworkRequest(NetworkRequest.Builder.from((NetworkRequest)this.getNetworkRequest()).setHeader("Accept", "application/json; charset=UTF-8").build());
        return this;
    }

    public <R> Request<T> setRequestData(R requestData, Gson gson) {
        return this.setRequestData(requestData, gson, gson.getAdapter(requestData.getClass()));
    }

    public <R> Request<T> setRequestData(R requestData) {
        return this.setRequestData(requestData, new Gson());
    }
}

