/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.converter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.http.MediaType;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import okio.Buffer;

public final class GsonRequestConverter<T>
implements Converter<T, NetworkRequest> {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    public GsonRequestConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }

    public NetworkRequest convert(T value) throws IOException {
        Buffer buffer = new Buffer();
        OutputStreamWriter writer = new OutputStreamWriter(buffer.outputStream(), UTF_8);
        JsonWriter jsonWriter = this.gson.newJsonWriter((Writer)writer);
        try {
            this.adapter.write(jsonWriter, value);
            jsonWriter.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return new NetworkRequest.Builder().setContentType(MEDIA_TYPE).setBody(buffer.readByteArray()).build();
    }
}

