/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.converter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.NetworkResponse;
import io.apptik.comm.jus.converter.GsonRequestConverter;
import io.apptik.comm.jus.converter.GsonResponseConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public final class GsonConverterFactory
extends Converter.Factory {
    private final Gson gson;

    public static GsonConverterFactory create() {
        return GsonConverterFactory.create(new Gson());
    }

    public static GsonConverterFactory create(Gson gson) {
        return new GsonConverterFactory(gson);
    }

    public GsonConverterFactory(Gson gson) {
        if (gson == null) {
            throw new NullPointerException("gson == null");
        }
        this.gson = gson;
    }

    public Converter<NetworkResponse, ?> fromResponse(Type type, Annotation[] annotations) {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonResponseConverter(adapter);
    }

    public Converter<?, NetworkRequest> toRequest(Type type, Annotation[] annotations) {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonRequestConverter(this.gson, adapter);
    }
}

