/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.ispn;

import io.apiman.common.auth.ISharedSecretSource;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;

public class InfinispanSharedSecretSource
implements ISharedSecretSource {
    private static final String DEFAULT_CACHE_CONTAINER = "java:jboss/infinispan/container/apiman-manager";
    private static final String DEFAULT_CACHE = "auth";
    private static final String SHARED_SECRET_KEY = "AUTH_SHARED_SECRET";
    private String cacheContainer;
    private String cacheName;
    private Cache<Object, Object> cache;
    private String secret;
    private Object mutex = new Object();

    public InfinispanSharedSecretSource() {
        this.cacheContainer = System.getProperty("apiman.manager.auth.cache-container", DEFAULT_CACHE_CONTAINER);
        this.cacheName = System.getProperty("apiman.manager.auth.cache", DEFAULT_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSharedSecret() {
        if (this.secret != null) {
            return this.secret;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.secret == null) {
                if (this.getCache().containsKey((Object)SHARED_SECRET_KEY)) {
                    this.secret = String.valueOf(this.getCache().get((Object)SHARED_SECRET_KEY));
                } else {
                    this.secret = UUID.randomUUID().toString();
                    this.getCache().put((Object)SHARED_SECRET_KEY, (Object)this.secret);
                }
            }
            return this.secret;
        }
    }

    private Cache<Object, Object> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        try {
            InitialContext ic = new InitialContext();
            CacheContainer container = (CacheContainer)ic.lookup(this.cacheContainer);
            this.cache = container.getCache(this.cacheName);
            return this.cache;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

