/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.resolver.ERCache;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.config.DefaultSchemaResolverConfig;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.serde.ParsedSchema;
import io.apicurio.registry.serde.SchemaLookupResult;
import io.apicurio.registry.serde.SchemaParser;
import io.apicurio.registry.serde.SchemaResolver;
import io.apicurio.registry.serde.data.KafkaSerdeMetadata;
import io.apicurio.registry.serde.data.KafkaSerdeRecord;
import io.apicurio.registry.serde.strategy.ArtifactReference;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.BasicAuth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

@Deprecated
public abstract class AbstractSchemaResolver<S, T>
implements SchemaResolver<S, T> {
    protected final ERCache<SchemaLookupResult<S>> schemaCache = new ERCache();
    protected io.apicurio.registry.resolver.SchemaParser<S, T> schemaParser;
    protected RegistryClient client;
    protected ApicurioHttpClient authClient;
    protected boolean isKey;
    protected ArtifactReferenceResolverStrategy<S, T> artifactResolverStrategy;
    protected String explicitArtifactGroupId;
    protected String explicitArtifactId;
    protected String explicitArtifactVersion;

    @Override
    public void configure(Map<String, ?> configs, final io.apicurio.registry.resolver.SchemaParser<S, T> schemaMapper) {
        this.schemaParser = schemaMapper;
        Object isKeyFromConfig = configs.get("apicurio.registry.is-key");
        this.configure(configs, (boolean)((Boolean)isKeyFromConfig), (SchemaParser<S>)new SchemaParser(){

            @Override
            public ArtifactType artifactType() {
                return schemaMapper.artifactType();
            }

            public Object parseSchema(byte[] rawSchema) {
                return schemaMapper.parseSchema(rawSchema, Collections.emptyMap());
            }
        });
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey, SchemaParser<S> schemaParser) {
        String artifactVersionOverride;
        String artifactIdOverride;
        this.isKey = isKey;
        DefaultSchemaResolverConfig config = new DefaultSchemaResolverConfig(configs);
        if (this.client == null) {
            String baseUrl = config.getRegistryUrl();
            if (baseUrl == null) {
                throw new IllegalArgumentException("Missing registry base url, set apicurio.registry.url");
            }
            String authServerURL = config.getAuthServiceUrl();
            String tokenEndpoint = config.getTokenEndpoint();
            try {
                String username;
                this.client = authServerURL != null || tokenEndpoint != null ? this.configureClientWithBearerAuthentication(config, baseUrl, authServerURL, tokenEndpoint) : ((username = config.getAuthUsername()) != null ? this.configureClientWithBasicAuth(config, baseUrl, username) : RegistryClientFactory.create((String)baseUrl, (Map)config.originals()));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        Object ais = config.getArtifactResolverStrategy();
        Utils.instantiate(ArtifactReferenceResolverStrategy.class, (Object)ais, this::setArtifactResolverStrategy);
        this.schemaCache.configureLifetime(config.getCheckPeriod());
        this.schemaCache.configureRetryBackoff(config.getRetryBackoff());
        this.schemaCache.configureRetryCount(config.getRetryCount());
        this.schemaCache.configureGlobalIdKeyExtractor(SchemaLookupResult::getGlobalId);
        this.schemaCache.configureContentKeyExtractor(schema -> Optional.ofNullable(schema.getRawSchema()).map(IoUtil::toString).orElse(null));
        this.schemaCache.configureContentIdKeyExtractor(SchemaLookupResult::getContentId);
        this.schemaCache.configureArtifactCoordinatesKeyExtractor(SchemaLookupResult::toArtifactCoordinates);
        this.schemaCache.checkInitialized();
        String groupIdOverride = config.getExplicitArtifactGroupId();
        if (groupIdOverride != null) {
            this.explicitArtifactGroupId = groupIdOverride;
        }
        if ((artifactIdOverride = config.getExplicitArtifactId()) != null) {
            this.explicitArtifactId = artifactIdOverride;
        }
        if ((artifactVersionOverride = config.getExplicitArtifactVersion()) != null) {
            this.explicitArtifactVersion = artifactVersionOverride;
        }
    }

    @Override
    public void setClient(RegistryClient client) {
        this.client = client;
    }

    public void setArtifactResolverStrategy(ArtifactReferenceResolverStrategy<S, T> artifactResolverStrategy) {
        this.artifactResolverStrategy = artifactResolverStrategy;
    }

    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    public io.apicurio.registry.resolver.SchemaParser<S, T> getSchemaParser() {
        return this.schemaParser;
    }

    protected ArtifactReference resolveArtifactReference(String topic, T data, ParsedSchema<S> parsedSchema) {
        KafkaSerdeMetadata metadata = new KafkaSerdeMetadata(topic, this.isKey, null);
        KafkaSerdeRecord<T> record = new KafkaSerdeRecord<T>(metadata, data);
        ParsedSchemaImpl ps = new ParsedSchemaImpl().setParsedSchema(parsedSchema.getParsedSchema()).setRawSchema(parsedSchema.getRawSchema());
        io.apicurio.registry.resolver.strategy.ArtifactReference artifactReference = this.artifactResolverStrategy.artifactReference(record, (io.apicurio.registry.resolver.ParsedSchema)ps);
        return ArtifactReference.builder().groupId(this.explicitArtifactGroupId == null ? artifactReference.getGroupId() : this.explicitArtifactGroupId).artifactId(this.explicitArtifactId == null ? artifactReference.getArtifactId() : this.explicitArtifactId).version(this.explicitArtifactVersion == null ? artifactReference.getVersion() : this.explicitArtifactVersion).build();
    }

    protected SchemaLookupResult<S> resolveSchemaByGlobalId(long globalId) {
        return (SchemaLookupResult)this.schemaCache.getByGlobalId(Long.valueOf(globalId), globalIdKey -> {
            InputStream rawSchema = this.client.getContentByGlobalId(globalIdKey.longValue());
            byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
            Object parsed = this.schemaParser.parseSchema(schema, Collections.emptyMap());
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            return result.globalId((long)globalIdKey).rawSchema(schema).schema(parsed).build();
        });
    }

    @Override
    public void reset() {
        this.schemaCache.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
        if (this.authClient != null) {
            this.authClient.close();
        }
    }

    private RegistryClient configureClientWithBearerAuthentication(DefaultSchemaResolverConfig config, String registryUrl, String authServerUrl, String tokenEndpoint) {
        OidcAuth auth = authServerUrl != null ? this.configureAuthWithRealm(config, authServerUrl) : this.configureAuthWithUrl(config, tokenEndpoint);
        return RegistryClientFactory.create((String)registryUrl, (Map)config.originals(), (Auth)auth);
    }

    private OidcAuth configureAuthWithRealm(DefaultSchemaResolverConfig config, String authServerUrl) {
        String realm = config.getAuthRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Missing registry auth realm, set apicurio.auth.realm");
        }
        String tokenEndpoint = authServerUrl + String.format("/realms/%s/protocol/openid-connect/token", realm);
        return this.configureAuthWithUrl(config, tokenEndpoint);
    }

    private OidcAuth configureAuthWithUrl(DefaultSchemaResolverConfig config, String tokenEndpoint) {
        String clientId = config.getAuthClientId();
        if (clientId == null) {
            throw new IllegalArgumentException("Missing registry auth clientId, set apicurio.auth.client.id");
        }
        String clientSecret = config.getAuthClientSecret();
        if (clientSecret == null) {
            throw new IllegalArgumentException("Missing registry auth secret, set apicurio.auth.client.secret");
        }
        this.authClient = ApicurioHttpClientFactory.create((String)tokenEndpoint, (RestClientErrorHandler)new AuthErrorHandler());
        return new OidcAuth(this.authClient, clientId, clientSecret);
    }

    private RegistryClient configureClientWithBasicAuth(DefaultSchemaResolverConfig config, String registryUrl, String username) {
        String password = config.getAuthPassword();
        if (password == null) {
            throw new IllegalArgumentException("Missing registry auth password, set apicurio.auth.password");
        }
        BasicAuth auth = new BasicAuth(username, password);
        return RegistryClientFactory.create((String)registryUrl, (Map)config.originals(), (Auth)auth);
    }

    protected void loadFromArtifactMetaData(ArtifactMetaData artifactMetadata, SchemaLookupResult.SchemaLookupResultBuilder<S> resultBuilder) {
        resultBuilder.globalId(artifactMetadata.getGlobalId());
        resultBuilder.contentId(artifactMetadata.getContentId());
        resultBuilder.groupId(artifactMetadata.getGroupId());
        resultBuilder.artifactId(artifactMetadata.getId());
        resultBuilder.version(String.valueOf(artifactMetadata.getVersion()));
    }

    protected void loadFromArtifactMetaData(VersionMetaData artifactMetadata, SchemaLookupResult.SchemaLookupResultBuilder<S> resultBuilder) {
        resultBuilder.globalId(artifactMetadata.getGlobalId());
        resultBuilder.contentId(artifactMetadata.getContentId());
        resultBuilder.groupId(artifactMetadata.getGroupId());
        resultBuilder.artifactId(artifactMetadata.getId());
        resultBuilder.version(String.valueOf(artifactMetadata.getVersion()));
    }
}

