/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import com.google.protobuf.Descriptors;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.protobuf.schema.FileDescriptorUtils;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import io.apicurio.registry.utils.protobuf.schema.ProtobufSchema;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class ProtobufContentValidator
implements ContentValidator {
    public void validate(ValidityLevel level, ContentHandle artifactContent, Map<String, ContentHandle> resolvedReferences) throws RuleViolationException {
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                if (resolvedReferences == null || resolvedReferences.isEmpty()) {
                    ProtobufFile.toProtoFileElement((String)artifactContent.content());
                } else {
                    ProtoFileElement protoFileElement = ProtobufFile.toProtoFileElement((String)artifactContent.content());
                    Map<String, ProtoFileElement> dependencies = Collections.unmodifiableMap(resolvedReferences.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ProtobufFile.toProtoFileElement((String)((ContentHandle)e.getValue()).content()))));
                    MessageElement firstMessage = FileDescriptorUtils.firstMessage((ProtoFileElement)protoFileElement);
                    if (firstMessage != null) {
                        try {
                            Descriptors.Descriptor fileDescriptor = FileDescriptorUtils.toDescriptor((String)firstMessage.getName(), (ProtoFileElement)protoFileElement, dependencies);
                            ContentHandle.create((String)fileDescriptor.toString());
                        }
                        catch (IllegalStateException ise) {
                            ContentHandle.create((String)this.getFileDescriptorFromElement(protoFileElement).toString());
                        }
                    } else {
                        ContentHandle.create((String)this.getFileDescriptorFromElement(protoFileElement).toString());
                    }
                }
            }
            catch (Exception e2) {
                throw new RuleViolationException("Syntax violation for Protobuf artifact.", RuleType.VALIDITY, level.name(), (Throwable)e2);
            }
        }
    }

    private ProtobufSchema getFileDescriptorFromElement(ProtoFileElement fileElem) throws Descriptors.DescriptorValidationException {
        Descriptors.FileDescriptor fileDescriptor = FileDescriptorUtils.protoFileToFileDescriptor((ProtoFileElement)fileElem);
        return new ProtobufSchema(fileDescriptor, fileElem);
    }
}

