/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceDescriptors;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;

public class InMemoryDiscoveryClient
implements DiscoveryAnnouncementClient,
DiscoveryLookupClient {
    private final AtomicReference<Set<ServiceDescriptor>> announcements = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    private final ConcurrentMap<UUID, ServiceDescriptor> discovered = new MapMaker().makeMap();
    private final NodeInfo nodeInfo;
    private final Duration maxAge;

    @Inject
    public InMemoryDiscoveryClient(NodeInfo nodeInfo) {
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.nodeInfo = nodeInfo;
        this.maxAge = DEFAULT_DELAY;
    }

    public InMemoryDiscoveryClient(NodeInfo nodeInfo, Duration maxAge) {
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(maxAge, "maxAge is null");
        this.nodeInfo = nodeInfo;
        this.maxAge = maxAge;
    }

    public ServiceDescriptor addDiscoveredService(ServiceDescriptor serviceDescriptor) {
        Objects.requireNonNull(serviceDescriptor, "serviceDescriptor is null");
        return this.discovered.put(serviceDescriptor.getId(), serviceDescriptor);
    }

    public ServiceDescriptor remove(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid is null");
        return (ServiceDescriptor)this.discovered.remove(uuid);
    }

    @Override
    public ListenableFuture<Duration> announce(Set<ServiceAnnouncement> services) {
        Objects.requireNonNull(services, "services is null");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ServiceAnnouncement service : services) {
            builder.add((Object)service.toServiceDescriptor(this.nodeInfo));
        }
        this.announcements.set((Set<ServiceDescriptor>)builder.build());
        return Futures.immediateFuture((Object)this.maxAge);
    }

    @Override
    public ListenableFuture<Void> unannounce() {
        this.announcements.set((Set<ServiceDescriptor>)ImmutableSet.of());
        return Futures.immediateFuture(null);
    }

    @Override
    public ListenableFuture<ServiceDescriptors> getServices(String type) {
        Objects.requireNonNull(type, "type is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ServiceDescriptor serviceDescriptor : this.announcements.get()) {
            if (!serviceDescriptor.getType().equals(type)) continue;
            builder.add((Object)serviceDescriptor);
        }
        for (ServiceDescriptor serviceDescriptor : this.discovered.values()) {
            if (!serviceDescriptor.getType().equals(type)) continue;
            builder.add((Object)serviceDescriptor);
        }
        return Futures.immediateFuture((Object)new ServiceDescriptors(type, null, (List<ServiceDescriptor>)builder.build(), this.maxAge, UUID.randomUUID().toString()));
    }

    @Override
    public ListenableFuture<ServiceDescriptors> getServices(String type, String pool) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(pool, "pool is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ServiceDescriptor serviceDescriptor : this.announcements.get()) {
            if (!serviceDescriptor.getType().equals(type) || !serviceDescriptor.getPool().equals(pool)) continue;
            builder.add((Object)serviceDescriptor);
        }
        for (ServiceDescriptor serviceDescriptor : this.discovered.values()) {
            if (!serviceDescriptor.getType().equals(type) || !serviceDescriptor.getPool().equals(pool)) continue;
            builder.add((Object)serviceDescriptor);
        }
        return Futures.immediateFuture((Object)new ServiceDescriptors(type, pool, (List<ServiceDescriptor>)builder.build(), this.maxAge, UUID.randomUUID().toString()));
    }

    @Override
    public ListenableFuture<ServiceDescriptors> refreshServices(ServiceDescriptors serviceDescriptors) {
        Objects.requireNonNull(serviceDescriptors, "serviceDescriptors is null");
        return this.getServices(serviceDescriptors.getType(), serviceDescriptors.getPool());
    }
}

