/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.aot.graalvm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import picocli.CommandLine;
import picocli.codegen.util.Util;

class OutputFileMixin {
    @CommandLine.Option(names={"-o", "--output"}, description={"Output file to write the configuration to. If not specified, the configuration is written to the standard output stream."})
    File outputFile;

    OutputFileMixin() {
    }

    void write(String text) throws IOException {
        if (text != null && text.length() > 0) {
            if (this.outputFile == null) {
                System.out.print(text);
            } else {
                this.writeToFile(text);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String result) throws IOException {
        FileWriter writer = null;
        try {
            File parent = this.outputFile.getAbsoluteFile().getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                System.err.println("Unable to mkdirs for " + this.outputFile.getAbsolutePath());
            }
            writer = new FileWriter(this.outputFile);
            writer.write(result);
        }
        catch (Throwable throwable) {
            Util.closeSilently(writer);
            throw throwable;
        }
        Util.closeSilently(writer);
    }
}

