/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter.model;

import gherkin.formatter.Argument;
import gherkin.formatter.Formatter;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Step
extends BasicStatement {
    private final List<DataTableRow> rows;
    private final DocString doc_string;

    public Step(List<Comment> comments, String keyword, String name, Integer line, List<DataTableRow> rows, DocString docString) {
        super(comments, keyword, name, line);
        this.rows = rows;
        this.doc_string = docString;
    }

    @Override
    public Range getLineRange() {
        Range range = super.getLineRange();
        if (this.getRows() != null) {
            range = new Range(range.getFirst(), this.getRows().get(this.getRows().size() - 1).getLine());
        } else if (this.getDocString() != null) {
            range = new Range(range.getFirst(), this.getDocString().getLineRange().getLast());
        }
        return range;
    }

    @Override
    public void replay(Formatter formatter) {
        formatter.step(this);
    }

    public List<Argument> getOutlineArgs() {
        ArrayList<Argument> result = new ArrayList<Argument>();
        Pattern p = Pattern.compile("<[^<]*>");
        Matcher matcher = p.matcher(this.getName());
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            result.add(new Argument(matchResult.start(), matchResult.group()));
        }
        return result;
    }

    public Match getOutlineMatch(String location) {
        return new Match(this.getOutlineArgs(), location);
    }

    public List<DataTableRow> getRows() {
        return this.rows;
    }

    public DocString getDocString() {
        return this.doc_string;
    }

    public StackTraceElement getStackTraceElement(String path) {
        return new StackTraceElement("\u273d", this.getKeyword() + this.getName(), path, this.getLine());
    }

    public static class Builder
    implements gherkin.formatter.model.Builder {
        private final List<Comment> comments;
        private final String keyword;
        private final String name;
        private final Integer line;
        private List<DataTableRow> rows;
        private DocString doc_string;

        public Builder(List<Comment> comments, String keyword, String name, Integer line) {
            this.comments = comments;
            this.keyword = keyword;
            this.name = name;
            this.line = line;
        }

        @Override
        public void row(List<Comment> comments, List<String> cells, Integer line, String id) {
            if (this.rows == null) {
                this.rows = new ArrayList<DataTableRow>();
            }
            this.rows.add(new DataTableRow(comments, cells, line));
        }

        @Override
        public void replay(Formatter formatter) {
            new Step(this.comments, this.keyword, this.name, this.line, this.rows, this.doc_string).replay(formatter);
        }

        @Override
        public void docString(DocString docString) {
            this.doc_string = docString;
        }
    }
}

