/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import gherkin.formatter.Filter;
import gherkin.formatter.Formatter;
import gherkin.formatter.LineFilter;
import gherkin.formatter.PatternFilter;
import gherkin.formatter.TagFilter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Range;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class FilterFormatter
implements Formatter {
    private final Formatter formatter;
    private final Filter filter;
    private List<Tag> featureTags;
    private List<Tag> featureElementTags;
    private List<Tag> examplesTags;
    private List<BasicStatement> featureEvents;
    private List<BasicStatement> backgroundEvents;
    private List<BasicStatement> featureElementEvents;
    private List<BasicStatement> examplesEvents;
    private String featureName;
    private String featureElementName;
    private String examplesName;
    private Range featureElementRange;
    private Range examplesRange;

    public FilterFormatter(Formatter formatter, List filters) {
        this.formatter = formatter;
        this.filter = this.detectFilter(filters);
        this.featureTags = new ArrayList<Tag>();
        this.featureElementTags = new ArrayList<Tag>();
        this.examplesTags = new ArrayList<Tag>();
        this.featureEvents = new ArrayList<BasicStatement>();
        this.backgroundEvents = new ArrayList<BasicStatement>();
        this.featureElementEvents = new ArrayList<BasicStatement>();
        this.examplesEvents = new ArrayList<BasicStatement>();
    }

    private Filter detectFilter(List filters) {
        Class<?> typeOfFilter = filters.get(0).getClass();
        if (String.class.isAssignableFrom(typeOfFilter)) {
            return new TagFilter(filters);
        }
        if (Number.class.isAssignableFrom(typeOfFilter)) {
            return new LineFilter(filters);
        }
        if (Pattern.class.isAssignableFrom(typeOfFilter)) {
            return new PatternFilter(filters);
        }
        throw new RuntimeException("Could not create filter method for unknown filter of type: " + typeOfFilter);
    }

    @Override
    public void uri(String uri) {
        this.formatter.uri(uri);
    }

    @Override
    public void feature(Feature feature) {
        this.featureTags = feature.getTags();
        this.featureName = feature.getName();
        this.featureEvents = new ArrayList<BasicStatement>();
        this.featureEvents.add(feature);
    }

    @Override
    public void background(Background background) {
        this.featureElementName = background.getName();
        this.featureElementRange = background.getLineRange();
        this.backgroundEvents = new ArrayList<BasicStatement>();
        this.backgroundEvents.add(background);
    }

    @Override
    public void scenario(Scenario scenario) {
        this.replay();
        this.featureElementTags = scenario.getTags();
        this.featureElementName = scenario.getName();
        this.featureElementRange = scenario.getLineRange();
        this.featureElementEvents = new ArrayList<BasicStatement>();
        this.featureElementEvents.add(scenario);
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.replay();
        this.featureElementTags = scenarioOutline.getTags();
        this.featureElementName = scenarioOutline.getName();
        this.featureElementRange = scenarioOutline.getLineRange();
        this.featureElementEvents = new ArrayList<BasicStatement>();
        this.featureElementEvents.add(scenarioOutline);
    }

    @Override
    public void examples(Examples examples) {
        Range tableBodyRange;
        this.replay();
        this.examplesTags = examples.getTags();
        this.examplesName = examples.getName();
        switch (examples.getRows().size()) {
            case 0: {
                tableBodyRange = new Range(examples.getLineRange().getLast(), examples.getLineRange().getLast());
                break;
            }
            case 1: {
                tableBodyRange = new Range(examples.getRows().get(0).getLine(), examples.getRows().get(0).getLine());
                break;
            }
            default: {
                tableBodyRange = new Range(examples.getRows().get(1).getLine(), examples.getRows().get(examples.getRows().size() - 1).getLine());
            }
        }
        this.examplesRange = new Range(examples.getLineRange().getFirst(), tableBodyRange.getLast());
        if (this.filter.eval(Collections.<Tag>emptyList(), Collections.<String>emptyList(), Collections.singletonList(tableBodyRange))) {
            examples.setRows(this.filter.filterTableBodyRows(examples.getRows()));
        }
        this.examplesEvents = new ArrayList<BasicStatement>();
        this.examplesEvents.add(examples);
    }

    @Override
    public void step(Step step) {
        if (!this.featureElementEvents.isEmpty()) {
            this.featureElementEvents.add(step);
        } else {
            this.backgroundEvents.add(step);
        }
        this.featureElementRange = new Range(this.featureElementRange.getFirst(), step.getLineRange().getLast());
    }

    public void table(List<Row> table) {
    }

    @Override
    public void eof() {
        this.replay();
        this.formatter.eof();
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void done() {
        this.formatter.done();
    }

    @Override
    public void close() {
        this.formatter.close();
    }

    private void replay() {
        ArrayList<Tag> feTags = new ArrayList<Tag>(this.featureTags);
        feTags.addAll(this.featureElementTags);
        List<String> feNames = Arrays.asList(this.featureName, this.featureElementName);
        List<Range> feRanges = Arrays.asList(this.featureElementRange);
        boolean featureElementOk = this.filter.eval(feTags, feNames, feRanges);
        ArrayList<Tag> exTags = new ArrayList<Tag>(feTags);
        exTags.addAll(this.examplesTags);
        ArrayList<String> exNames = new ArrayList<String>(feNames);
        exNames.add(this.examplesName);
        ArrayList<Range> exRanges = new ArrayList<Range>(feRanges);
        exRanges.add(this.examplesRange);
        boolean examplesOk = this.filter.eval(exTags, exNames, exRanges);
        if (featureElementOk || examplesOk) {
            this.replayEvents(this.featureEvents);
            this.replayEvents(this.backgroundEvents);
            this.replayEvents(this.featureElementEvents);
            if (examplesOk) {
                this.replayEvents(this.examplesEvents);
            }
        }
        this.examplesEvents.clear();
        this.examplesTags.clear();
        this.examplesName = null;
        this.examplesRange = null;
    }

    private void replayEvents(List<BasicStatement> events) {
        for (BasicStatement event : events) {
            event.replay(this.formatter);
        }
        events.clear();
    }
}

