/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java8.StepdefBody;
import cucumber.runtime.CucumberException;
import cucumber.runtime.JdkPatternArgumentMatcher;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import cucumber.runtime.java.TypeIntrospector;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Java8StepDefinition
implements StepDefinition {
    private final Pattern pattern;
    private final long timeoutMillis;
    private final StepdefBody body;
    private final JdkPatternArgumentMatcher argumentMatcher;
    private final StackTraceElement location;
    private final List<ParameterInfo> parameterInfos;
    private final Method method;

    public Java8StepDefinition(Pattern pattern, long timeoutMillis, StepdefBody body, TypeIntrospector typeIntrospector) throws Exception {
        this.pattern = pattern;
        this.timeoutMillis = timeoutMillis;
        this.body = body;
        this.argumentMatcher = new JdkPatternArgumentMatcher(pattern);
        this.location = new Exception().getStackTrace()[3];
        Class<?> bodyClass = body.getClass();
        this.method = this.getAcceptMethod(bodyClass);
        this.parameterInfos = this.getParameterInfos(bodyClass, typeIntrospector, this.method.getParameterTypes().length);
    }

    private List<ParameterInfo> getParameterInfos(Class<? extends StepdefBody> bodyClass, TypeIntrospector typeIntrospector, int parameterCount) throws Exception {
        Type[] argumentTypes;
        Type genericInterface = bodyClass.getGenericInterfaces()[0];
        if (genericInterface instanceof ParameterizedType) {
            argumentTypes = ((ParameterizedType)genericInterface).getActualTypeArguments();
        } else {
            Class<?> interfac3 = bodyClass.getInterfaces()[0];
            argumentTypes = typeIntrospector.getGenericTypes(bodyClass, interfac3);
        }
        Type[] argumentTypesOfCorrectLength = new Type[parameterCount];
        System.arraycopy(argumentTypes, argumentTypes.length - parameterCount, argumentTypesOfCorrectLength, 0, parameterCount);
        this.verifyNotListOrMap(argumentTypesOfCorrectLength);
        return ParameterInfo.fromTypes((Type[])argumentTypesOfCorrectLength);
    }

    private Method getAcceptMethod(Class<? extends StepdefBody> bodyClass) {
        ArrayList<Method> acceptMethods = new ArrayList<Method>();
        for (Method method : bodyClass.getDeclaredMethods()) {
            if (method.isBridge() || method.isSynthetic() || !"accept".equals(method.getName())) continue;
            acceptMethods.add(method);
        }
        if (acceptMethods.size() != 1) {
            throw new IllegalStateException(String.format("Expected single 'accept' method on body class, found '%s'", acceptMethods));
        }
        return (Method)acceptMethods.get(0);
    }

    private void verifyNotListOrMap(Type[] argumentTypes) {
        for (Type argumentType : argumentTypes) {
            Class argumentClass;
            if (!(argumentType instanceof Class) || !List.class.isAssignableFrom(argumentClass = (Class)argumentType) && !Map.class.isAssignableFrom(argumentClass)) continue;
            throw this.withLocation(new CucumberException("Can't use " + argumentClass.getName() + " in lambda step definition. Declare a DataTable argument instead and convert manually with asList/asLists/asMap/asMaps"));
        }
    }

    private CucumberException withLocation(CucumberException exception) {
        exception.setStackTrace(new StackTraceElement[]{this.location});
        return exception;
    }

    public List<Argument> matchedArguments(Step step) {
        return this.argumentMatcher.argumentsFrom(step.getName());
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public Integer getParameterCount() {
        return this.parameterInfos.size();
    }

    public ParameterInfo getParameterType(int n, Type argumentType) throws IndexOutOfBoundsException {
        return this.parameterInfos.get(n);
    }

    public void execute(I18n i18n, Object[] args) throws Throwable {
        Utils.invoke((Object)this.body, (Method)this.method, (long)this.timeoutMillis, (Object[])args);
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public boolean isScenarioScoped() {
        return true;
    }
}

