/*
 * Decompiled with CFR 0.152.
 */
package cucumber.table;

import cucumber.runtime.CucumberException;
import cucumber.runtime.Utils;
import cucumber.runtime.converters.LocalizedXStreams;
import cucumber.runtime.xstream.converters.ConversionException;
import cucumber.runtime.xstream.converters.SingleValueConverter;
import cucumber.runtime.xstream.converters.reflection.AbstractReflectionConverter;
import cucumber.table.CamelCaseStringConverter;
import cucumber.table.DataTable;
import cucumber.table.xstream.CellWriter;
import cucumber.table.xstream.ComplexTypeWriter;
import cucumber.table.xstream.ListOfComplexTypeReader;
import cucumber.table.xstream.ListOfSingleValueWriter;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import gherkin.util.FixJava;
import gherkin.util.Mapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableConverter {
    private static final List<Comment> NO_COMMENTS = Collections.emptyList();
    private final LocalizedXStreams.LocalizedXStream xStream;
    private final String dateFormat;

    public TableConverter(LocalizedXStreams.LocalizedXStream xStream, String dateFormat) {
        this.xStream = xStream;
        this.dateFormat = dateFormat;
    }

    public <T> T convert(Type type, DataTable dataTable) {
        try {
            this.xStream.setDateFormat(this.dateFormat);
            if (type == null || type instanceof Class && ((Class)type).isAssignableFrom(DataTable.class)) {
                DataTable dataTable2 = dataTable;
                return (T)dataTable2;
            }
            Type itemType = Utils.listItemType(type);
            if (itemType == null) {
                throw new CucumberException("Not a List type: " + type);
            }
            Type listItemType = Utils.listItemType(itemType);
            if (listItemType == null) {
                SingleValueConverter singleValueConverter = this.xStream.getSingleValueConverter(itemType);
                if (singleValueConverter != null) {
                    List<Object> list = this.toListOfSingleValue(dataTable, singleValueConverter);
                    return (T)list;
                }
                if (itemType instanceof Class) {
                    if (Map.class.equals((Object)itemType)) {
                        SingleValueConverter mapKeyConverter = this.xStream.getSingleValueConverter((Type)((Object)String.class));
                        SingleValueConverter mapValueConverter = this.xStream.getSingleValueConverter((Type)((Object)String.class));
                        List<Map<Object, Object>> list = this.toListOfSingleValueMap(dataTable, mapKeyConverter, mapValueConverter);
                        return (T)list;
                    }
                    List<T> mapKeyConverter = this.toListOfComplexType(dataTable, (Class)itemType);
                    return (T)mapKeyConverter;
                }
                SingleValueConverter mapKeyConverter = this.xStream.getSingleValueConverter(Utils.mapKeyType(itemType));
                SingleValueConverter mapValueConverter = this.xStream.getSingleValueConverter(Utils.mapValueType(itemType));
                if (mapKeyConverter != null && mapValueConverter != null) {
                    List<Map<Object, Object>> list = this.toListOfSingleValueMap(dataTable, mapKeyConverter, mapValueConverter);
                    return (T)list;
                }
                throw new CucumberException("Can't convert a table to " + type + ". When using List<SomeComplexType>, SomeComplexType must not be a generic type");
            }
            SingleValueConverter singleValueConverter = this.xStream.getSingleValueConverter(listItemType);
            if (singleValueConverter != null) {
                List<List<Object>> list = this.toListOfListOfSingleValue(dataTable, singleValueConverter);
                return (T)list;
            }
            throw new CucumberException("Can't convert to " + type.toString());
        }
        finally {
            this.xStream.unsetDateFormat();
        }
    }

    private <T> List<T> toListOfComplexType(DataTable dataTable, Class<T> itemType) {
        ListOfComplexTypeReader reader = new ListOfComplexTypeReader(itemType, this.convertTopCellsToFieldNames(dataTable), dataTable.cells(1));
        try {
            return Collections.unmodifiableList((List)this.xStream.unmarshal(reader));
        }
        catch (AbstractReflectionConverter.UnknownFieldException e) {
            throw new CucumberException(e.getShortMessage());
        }
        catch (ConversionException e) {
            throw new CucumberException(String.format("Can't assign null value to one of the primitive fields in %s. Please use boxed types.", e.get("class")));
        }
    }

    private List<Object> toListOfSingleValue(DataTable dataTable, SingleValueConverter singleValueConverter) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String cell : dataTable.flatten()) {
            result.add(singleValueConverter.fromString(cell));
        }
        return Collections.unmodifiableList(result);
    }

    private List<List<Object>> toListOfListOfSingleValue(DataTable dataTable, SingleValueConverter singleValueConverter) {
        ArrayList result = new ArrayList();
        for (List<String> row : dataTable.raw()) {
            ArrayList<Object> convertedRow = new ArrayList<Object>();
            for (String cell : row) {
                convertedRow.add(singleValueConverter.fromString(cell));
            }
            result.add(Collections.unmodifiableList(convertedRow));
        }
        return Collections.unmodifiableList(result);
    }

    private List<Map<Object, Object>> toListOfSingleValueMap(DataTable dataTable, SingleValueConverter mapKeyConverter, SingleValueConverter mapValueConverter) {
        ArrayList result = new ArrayList();
        List<String> keyStrings = dataTable.topCells();
        ArrayList<Object> keys = new ArrayList<Object>();
        for (String keyString : keyStrings) {
            keys.add(mapKeyConverter.fromString(keyString));
        }
        List<List<String>> valueRows = dataTable.cells(1);
        for (List<String> valueRow : valueRows) {
            HashMap map = new HashMap();
            int i = 0;
            for (String cell : valueRow) {
                map.put(keys.get(i), mapValueConverter.fromString(cell));
                ++i;
            }
            result.add(Collections.unmodifiableMap(map));
        }
        return Collections.unmodifiableList(result);
    }

    public <T> List<T> toList(Type type, DataTable dataTable) {
        if (type == null) {
            return (List)this.convert(new GenericListType(new GenericListType((Type)((Object)String.class))), dataTable);
        }
        return (List)this.convert(new GenericListType(type), dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable toTable(List<?> objects, String ... columnNames) {
        try {
            this.xStream.setDateFormat(this.dateFormat);
            List<String> header = null;
            ArrayList<List<String>> valuesList = new ArrayList<List<String>>();
            for (Object object : objects) {
                CellWriter writer;
                if (this.isListOfSingleValue(object)) {
                    object = new ArrayList((List)object);
                    writer = new ListOfSingleValueWriter();
                } else {
                    writer = new ComplexTypeWriter(Arrays.asList(columnNames));
                }
                this.xStream.marshal(object, writer);
                if (header == null) {
                    header = writer.getHeader();
                }
                List<String> values = writer.getValues();
                valuesList.add(values);
            }
            DataTable dataTable = this.createDataTable(header, valuesList);
            return dataTable;
        }
        finally {
            this.xStream.unsetDateFormat();
        }
    }

    private DataTable createDataTable(List<String> header, List<List<String>> valuesList) {
        ArrayList<DataTableRow> gherkinRows = new ArrayList<DataTableRow>();
        if (header != null) {
            gherkinRows.add(this.gherkinRow(header));
        }
        for (List<String> values : valuesList) {
            gherkinRows.add(this.gherkinRow(values));
        }
        return new DataTable(gherkinRows, this);
    }

    private DataTableRow gherkinRow(List<String> cells) {
        return new DataTableRow(NO_COMMENTS, cells, Integer.valueOf(0));
    }

    private List<String> convertTopCellsToFieldNames(DataTable dataTable) {
        final CamelCaseStringConverter mapper = new CamelCaseStringConverter();
        return FixJava.map(dataTable.topCells(), (Mapper)new Mapper<String, String>(){

            public String map(String attributeName) {
                return mapper.map(attributeName);
            }
        });
    }

    private boolean isListOfSingleValue(Object object) {
        if (object instanceof List) {
            boolean isSingleValue;
            List list = (List)object;
            boolean bl = isSingleValue = this.xStream.getSingleValueConverter(list.get(0).getClass()) != null;
            if (list.size() > 0 && isSingleValue) {
                return true;
            }
        }
        return false;
    }

    private static class GenericListType
    implements ParameterizedType {
        private final Type type;

        public GenericListType(Type type) {
            this.type = type;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.type};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            throw new UnsupportedOperationException();
        }
    }
}

