/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.converters;

import cucumber.runtime.converters.BigDecimalConverter;
import cucumber.runtime.converters.BigIntegerConverter;
import cucumber.runtime.converters.ByteConverter;
import cucumber.runtime.converters.CalendarConverter;
import cucumber.runtime.converters.ClassWithStringConstructorConverter;
import cucumber.runtime.converters.DateConverter;
import cucumber.runtime.converters.DoubleConverter;
import cucumber.runtime.converters.EnumConverter;
import cucumber.runtime.converters.FloatConverter;
import cucumber.runtime.converters.IntegerConverter;
import cucumber.runtime.converters.LongConverter;
import cucumber.runtime.converters.SingleValueConverterWrapperExt;
import cucumber.runtime.converters.TimeConverter;
import cucumber.runtime.xstream.XStream;
import cucumber.runtime.xstream.converters.Converter;
import cucumber.runtime.xstream.converters.ConverterLookup;
import cucumber.runtime.xstream.converters.ConverterRegistry;
import cucumber.runtime.xstream.converters.SingleValueConverter;
import cucumber.runtime.xstream.core.DefaultConverterLookup;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocalizedXStreams {
    private final Map<Locale, LocalizedXStream> xStreamsByLocale = new HashMap<Locale, LocalizedXStream>();
    private final ClassLoader classLoader;

    public LocalizedXStreams(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public LocalizedXStream get(Locale locale) {
        LocalizedXStream xStream = this.xStreamsByLocale.get(locale);
        if (xStream == null) {
            xStream = this.newXStream(locale);
            this.xStreamsByLocale.put(locale, xStream);
        }
        return xStream;
    }

    private LocalizedXStream newXStream(Locale locale) {
        DefaultConverterLookup lookup = new DefaultConverterLookup();
        return new LocalizedXStream(this.classLoader, lookup, lookup, locale);
    }

    public static class LocalizedXStream
    extends XStream {
        private final Locale locale;
        private static final List<TimeConverter> timeConverters = new ArrayList<TimeConverter>();

        public LocalizedXStream(ClassLoader classLoader, ConverterLookup converterLookup, ConverterRegistry converterRegistry, Locale locale) {
            super(null, null, classLoader, null, converterLookup, converterRegistry);
            this.locale = locale;
            this.autodetectAnnotations(true);
            this.register(converterRegistry, new BigDecimalConverter(locale));
            this.register(converterRegistry, new BigIntegerConverter(locale));
            this.register(converterRegistry, new ByteConverter(locale));
            this.register(converterRegistry, new DateConverter(locale));
            this.register(converterRegistry, new CalendarConverter(locale));
            this.register(converterRegistry, new DoubleConverter(locale));
            this.register(converterRegistry, new FloatConverter(locale));
            this.register(converterRegistry, new IntegerConverter(locale));
            this.register(converterRegistry, new LongConverter(locale));
            converterRegistry.registerConverter(new SingleValueConverterWrapperExt(new ClassWithStringConstructorConverter()), -10);
        }

        private void register(ConverterRegistry lookup, SingleValueConverter converter) {
            lookup.registerConverter(new SingleValueConverterWrapperExt(converter), 10000);
        }

        public void setDateFormat(String dateFormat) {
            if (dateFormat != null) {
                List<Class> timeClasses = TimeConverter.getTimeClasses();
                for (Class timeClass : timeClasses) {
                    SingleValueConverterWrapperExt converterWrapper = (SingleValueConverterWrapperExt)this.getConverterLookup().lookupConverterForType(timeClass);
                    TimeConverter timeConverter = (TimeConverter)converterWrapper.getConverter();
                    timeConverter.setOnlyFormat(dateFormat, this.locale);
                    timeConverters.add(timeConverter);
                }
            }
        }

        public void unsetDateFormat() {
            for (TimeConverter timeConverter : timeConverters) {
                timeConverter.removeOnlyFormat();
            }
            timeConverters.clear();
        }

        public SingleValueConverter getSingleValueConverter(Type type) {
            if (Object.class.equals(type)) {
                type = String.class;
            }
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (clazz.isEnum()) {
                    return new EnumConverter(this.locale, clazz);
                }
                Converter converter = this.getConverterLookup().lookupConverterForType((Class)type);
                return converter instanceof SingleValueConverter ? (SingleValueConverter)((Object)converter) : null;
            }
            return null;
        }
    }
}

