/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.converters;

import cucumber.runtime.converters.ConverterWithFormat;
import cucumber.runtime.xstream.converters.ConversionException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ConverterWithEnumFormat<T extends Enum>
extends ConverterWithFormat<T> {
    private final List<Format> formats = new ArrayList<Format>();
    private final Locale locale;
    private final Class<? extends Enum> typeClass;

    ConverterWithEnumFormat(Locale locale, Class<? extends Enum> enumClass) {
        super(new Class[]{enumClass});
        this.locale = locale;
        this.typeClass = enumClass;
        this.formats.add(new LowercaseFormat());
        this.formats.add(new UppercaseFormat());
        this.formats.add(new CapitalizeFormat());
    }

    @Override
    public T fromString(String string) {
        try {
            return (T)((Enum)super.fromString(string));
        }
        catch (ConversionException e) {
            String allowed = Arrays.asList(this.typeClass.getEnumConstants()).toString();
            throw new ConversionException(String.format("Couldn't convert %s to %s. Legal values are %s", string, this.typeClass.getName(), allowed));
        }
    }

    @Override
    public List<Format> getFormats() {
        return this.formats;
    }

    private class CapitalizeFormat
    extends Format {
        private CapitalizeFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(String.valueOf(obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            String firstLetter = source.substring(0, 1);
            String restOfTheString = source.substring(1, source.length());
            return Enum.valueOf(ConverterWithEnumFormat.this.typeClass, firstLetter.toUpperCase(ConverterWithEnumFormat.this.locale) + restOfTheString);
        }
    }

    private class UppercaseFormat
    extends Format {
        private UppercaseFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(String.valueOf(obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return source == null ? null : Enum.valueOf(ConverterWithEnumFormat.this.typeClass, source.toUpperCase(ConverterWithEnumFormat.this.locale));
        }
    }

    private class LowercaseFormat
    extends Format {
        private LowercaseFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(String.valueOf(obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return source == null ? null : Enum.valueOf(ConverterWithEnumFormat.this.typeClass, source.toLowerCase(ConverterWithEnumFormat.this.locale));
        }
    }
}

