/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.GenericOperator;
import org.cqframework.cql.cql2elm.model.InstantiationResult;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorMap;
import org.cqframework.cql.cql2elm.model.OperatorResolution;
import org.cqframework.cql.cql2elm.model.Signature;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.DataType;

public class OperatorEntry {
    private String name;
    private SignatureNodes signatures = new SignatureNodes();
    private Map<Signature, GenericOperator> genericOperators = new HashMap<Signature, GenericOperator>();

    public OperatorEntry(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name is null or empty");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean containsOperator(Operator operator) {
        if (operator instanceof GenericOperator) {
            return this.containsGenericOperator((GenericOperator)operator);
        }
        return this.signatures.contains(operator);
    }

    public void addOperator(Operator operator) {
        if (operator instanceof GenericOperator) {
            this.addGenericOperator((GenericOperator)operator);
        } else {
            this.signatures.add(new SignatureNode(operator));
        }
    }

    private boolean containsGenericOperator(GenericOperator operator) {
        return this.genericOperators.containsKey(operator.getSignature());
    }

    private void addGenericOperator(GenericOperator operator) {
        if (this.genericOperators.containsKey(operator.getSignature())) {
            throw new IllegalArgumentException(String.format("Operator %s already has a generic registration for signature: %s.", this.name, operator.getSignature().toString()));
        }
        this.genericOperators.put(operator.getSignature(), operator);
    }

    private boolean allResultsUseConversion(List<OperatorResolution> results) {
        for (OperatorResolution resolution : results) {
            if (resolution.hasConversions()) continue;
            return false;
        }
        return true;
    }

    public List<Signature> expandChoices(Signature callSignature) {
        ArrayList<Signature> signatures = new ArrayList<Signature>();
        if (callSignature.containsChoices()) {
            ArrayList<ArrayList<DataType>> operandList = new ArrayList<ArrayList<DataType>>();
            for (DataType operand : callSignature.getOperandTypes()) {
                ArrayList<DataType> list = new ArrayList<DataType>();
                if (operand instanceof ChoiceType) {
                    for (DataType type : ((ChoiceType)operand).getTypes()) {
                        list.add(type);
                    }
                } else {
                    list.add(operand);
                }
                operandList.add(list);
            }
            DataType[] result = new DataType[callSignature.getSize()];
            this.collectSignatures(operandList, result, 0, signatures);
        } else {
            signatures.add(callSignature);
        }
        return signatures;
    }

    private void collectSignatures(ArrayList<ArrayList<DataType>> operandList, DataType[] result, int k, List<Signature> signatures) {
        if (k == operandList.size()) {
            signatures.add(new Signature(result));
        } else {
            for (int j = 0; j < operandList.get(k).size(); ++j) {
                result[k] = operandList.get(k).get(j);
                this.collectSignatures(operandList, result, k + 1, signatures);
            }
        }
    }

    public List<OperatorResolution> resolve(CallContext callContext, OperatorMap operatorMap, ConversionMap conversionMap) {
        if (callContext == null) {
            throw new IllegalArgumentException("callContext is null");
        }
        List<OperatorResolution> results = this.signatures.resolve(callContext, conversionMap, operatorMap);
        if (results == null || this.allResultsUseConversion(results)) {
            boolean signaturesInstantiated = false;
            List<Signature> callSignatures = this.expandChoices(callContext.getSignature());
            for (Signature callSignature : callSignatures) {
                Operator result = this.instantiate(callSignature, operatorMap, conversionMap, callContext.getAllowPromotionAndDemotion());
                if (result == null || this.signatures.contains(result)) continue;
                this.signatures.add(new SignatureNode(result));
                signaturesInstantiated = true;
            }
            if (signaturesInstantiated) {
                results = this.signatures.resolve(callContext, conversionMap, operatorMap);
            }
        }
        return results;
    }

    private Operator instantiate(Signature signature, OperatorMap operatorMap, ConversionMap conversionMap, boolean allowPromotionAndDemotion) {
        ArrayList instantiations = new ArrayList();
        int lowestConversionScore = Integer.MAX_VALUE;
        Operator instantiation = null;
        for (GenericOperator genericOperator : this.genericOperators.values()) {
            InstantiationResult instantiationResult = genericOperator.instantiate(signature, operatorMap, conversionMap, allowPromotionAndDemotion);
            if (instantiationResult.getOperator() == null || instantiationResult.getConversionScore() > lowestConversionScore) continue;
            if (instantiation == null || instantiationResult.getConversionScore() < lowestConversionScore) {
                instantiation = instantiationResult.getOperator();
                lowestConversionScore = instantiationResult.getConversionScore();
                continue;
            }
            throw new IllegalArgumentException(String.format("Ambiguous generic instantiation of operator %s between signature %s and %s.", this.name, instantiation.getSignature().toString(), instantiationResult.getOperator().getSignature().toString()));
        }
        return instantiation;
    }

    private static class SignatureNodes {
        private Map<Signature, SignatureNode> signatures = new HashMap<Signature, SignatureNode>();

        private SignatureNodes() {
        }

        public boolean contains(Operator operator) {
            boolean result = this.signatures.containsKey(operator.getSignature());
            if (!result) {
                for (SignatureNode n : this.signatures.values()) {
                    result = n.subSignatures.contains(operator);
                    if (!result) continue;
                    break;
                }
            }
            return result;
        }

        public void add(SignatureNode node) {
            if (node == null) {
                throw new IllegalArgumentException("node is null.");
            }
            if (this.signatures.containsKey(node.getSignature())) {
                throw new IllegalArgumentException(String.format("Operator %s already has a registration for signature: %s.", node.operator.getName(), node.getSignature().toString()));
            }
            boolean added = false;
            for (SignatureNode n : this.signatures.values()) {
                if (!n.getSignature().isSuperTypeOf(node.getSignature())) continue;
                n.subSignatures.add(node);
                added = true;
                break;
            }
            if (!added) {
                for (SignatureNode n : this.signatures.values().toArray(new SignatureNode[this.signatures.size()])) {
                    if (!node.getSignature().isSuperTypeOf(n.getSignature())) continue;
                    this.signatures.remove(n.getSignature());
                    node.subSignatures.add(n);
                }
                this.signatures.put(node.getSignature(), node);
            }
        }

        public List<OperatorResolution> resolve(CallContext callContext, ConversionMap conversionMap, OperatorMap operatorMap) {
            ArrayList<OperatorResolution> results = null;
            int signatureCount = 0;
            for (SignatureNode n : this.signatures.values()) {
                List<OperatorResolution> nodeResults;
                if (n.getSignature().getSize() == callContext.getSignature().getSize()) {
                    ++signatureCount;
                }
                if ((nodeResults = n.resolve(callContext, conversionMap, operatorMap)) == null) continue;
                if (results == null) {
                    results = new ArrayList<OperatorResolution>();
                }
                results.addAll(nodeResults);
            }
            if (results != null && signatureCount > 1) {
                for (OperatorResolution result : results) {
                    result.setOperatorHasOverloads();
                }
            }
            return results;
        }
    }

    private static class SignatureNode {
        private Operator operator;
        private SignatureNodes subSignatures = new SignatureNodes();

        public SignatureNode(Operator operator) {
            if (operator == null) {
                throw new IllegalArgumentException("operator is null.");
            }
            this.operator = operator;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Signature getSignature() {
            return this.operator.getSignature();
        }

        public List<OperatorResolution> resolve(CallContext callContext, ConversionMap conversionMap, OperatorMap operatorMap) {
            List<Object> results = null;
            if (this.operator.getSignature().equals(callContext.getSignature())) {
                results = new ArrayList<OperatorResolution>();
                results.add(new OperatorResolution(this.operator));
                return results;
            }
            results = this.subSignatures.resolve(callContext, conversionMap, operatorMap);
            if (results == null && this.operator.getSignature().isSuperTypeOf(callContext.getSignature())) {
                results = new ArrayList();
                results.add(new OperatorResolution(this.operator));
            }
            if (results == null && conversionMap != null) {
                Conversion[] conversions = new Conversion[this.operator.getSignature().getSize()];
                boolean isConvertible = callContext.getSignature().isConvertibleTo(this.operator.getSignature(), conversionMap, operatorMap, callContext.getAllowPromotionAndDemotion(), conversions);
                if (isConvertible) {
                    OperatorResolution resolution = new OperatorResolution(this.operator);
                    resolution.setConversions(conversions);
                    results = new ArrayList();
                    results.add(resolution);
                }
            }
            return results;
        }

        public int hashCode() {
            return this.operator.getSignature().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SignatureNode) {
                SignatureNode that = (SignatureNode)o;
                return this.operator.getName().equals(that.operator.getName()) && this.getSignature().equals(that.getSignature());
            }
            return false;
        }

        public String toString() {
            return this.operator.toString();
        }
    }
}

