/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cqframework.cql.cql2elm.CqlCompilerOptions;
import org.hl7.cql_annotations.r1.CqlToElmBase;
import org.hl7.cql_annotations.r1.CqlToElmInfo;
import org.hl7.elm.r1.Library;

public class CompilerOptions {
    private CompilerOptions() {
    }

    public static Set<CqlCompilerOptions.Options> getCompilerOptions(Library library) {
        Objects.requireNonNull(library, "library can not be null");
        if (library.getAnnotation() == null || library.getAnnotation().isEmpty()) {
            return null;
        }
        String compilerOptions = CompilerOptions.getCompilerOptions(library.getAnnotation());
        return CompilerOptions.parseCompilerOptions(compilerOptions);
    }

    private static String getCompilerOptions(List<CqlToElmBase> annotations) {
        for (CqlToElmBase base : annotations) {
            if (!(base instanceof CqlToElmInfo) || ((CqlToElmInfo)base).getTranslatorOptions() == null) continue;
            return ((CqlToElmInfo)base).getTranslatorOptions();
        }
        return null;
    }

    public static Set<CqlCompilerOptions.Options> parseCompilerOptions(String compilerOptions) {
        String[] options;
        if (compilerOptions == null || compilerOptions.isEmpty()) {
            return null;
        }
        EnumSet<CqlCompilerOptions.Options> optionSet = EnumSet.noneOf(CqlCompilerOptions.Options.class);
        for (String option : options = compilerOptions.trim().split(",")) {
            optionSet.add(CqlCompilerOptions.Options.valueOf(option));
        }
        return optionSet;
    }

    public static String getCompilerVersion(Library library) {
        Objects.requireNonNull(library, "library can not be null");
        if (library.getAnnotation() == null || library.getAnnotation().isEmpty()) {
            return null;
        }
        return CompilerOptions.getCompilerVersion(library.getAnnotation());
    }

    private static String getCompilerVersion(List<CqlToElmBase> annotations) {
        for (CqlToElmBase o : annotations) {
            if (!(o instanceof CqlToElmInfo)) continue;
            CqlToElmInfo c = (CqlToElmInfo)o;
            return c.getTranslatorVersion();
        }
        return null;
    }
}

