/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.type;

import com.google.common.base.Optional;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Options;
import java.util.Arrays;
import java.util.List;

public class OptionsBuilder {
    private static final NoOptions noOptions = new NoOptions();

    public static NoOptions noOptions() {
        return noOptions;
    }

    public static InternalOptionsBuilder withConsistency(ConsistencyLevel consistencyLevel) {
        return new InternalOptionsBuilder(consistencyLevel);
    }

    public static InternalOptionsBuilder withTtl(Integer ttl) {
        return new InternalOptionsBuilder(ttl);
    }

    public static InternalOptionsBuilder withTimestamp(Long timestamp) {
        return new InternalOptionsBuilder(timestamp);
    }

    public static InternalOptionsBuilder ifNotExists() {
        return new InternalOptionsBuilder(true);
    }

    public static InternalOptionsBuilder ifConditions(Options.CASCondition ... CASConditions) {
        return new InternalOptionsBuilder(CASConditions);
    }

    public static InternalOptionsBuilder casResultListener(CASResultListener listener) {
        return new InternalOptionsBuilder(listener);
    }

    public static InternalOptionsBuilder casLocalSerial() {
        return new InternalOptionsBuilder((Optional<com.datastax.driver.core.ConsistencyLevel>)Optional.fromNullable((Object)com.datastax.driver.core.ConsistencyLevel.LOCAL_SERIAL));
    }

    public static class InternalOptionsBuilder
    extends Options {
        protected InternalOptionsBuilder(ConsistencyLevel consistencyLevel) {
            this.consistency = consistencyLevel;
        }

        protected InternalOptionsBuilder(Integer ttl) {
            this.ttl = ttl;
        }

        protected InternalOptionsBuilder(Long timestamp) {
            this.timestamp = timestamp;
        }

        protected InternalOptionsBuilder(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
        }

        protected InternalOptionsBuilder(Options.CASCondition ... CASConditions) {
            this.CASConditions = Arrays.asList(CASConditions);
        }

        protected InternalOptionsBuilder(CASResultListener listener) {
            this.CASResultListenerO = Optional.fromNullable((Object)listener);
        }

        protected InternalOptionsBuilder(Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyO) {
            this.serialConsistencyO = serialConsistencyO;
        }

        public InternalOptionsBuilder withConsistency(ConsistencyLevel consistencyLevel) {
            this.consistency = consistencyLevel;
            return this;
        }

        public InternalOptionsBuilder withTtl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public InternalOptionsBuilder withTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public InternalOptionsBuilder ifNotExists() {
            this.ifNotExists = true;
            return this;
        }

        public InternalOptionsBuilder casResultListener(CASResultListener listener) {
            this.CASResultListenerO = Optional.fromNullable((Object)listener);
            return this;
        }

        public InternalOptionsBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        public InternalOptionsBuilder ifConditions(Options.CASCondition ... CASConditions) {
            this.CASConditions = Arrays.asList(CASConditions);
            return this;
        }

        public InternalOptionsBuilder ifConditions(List<Options.CASCondition> CASConditions) {
            this.CASConditions = CASConditions;
            return this;
        }

        public InternalOptionsBuilder casLocalSerial() {
            this.serialConsistencyO = Optional.fromNullable((Object)com.datastax.driver.core.ConsistencyLevel.LOCAL_SERIAL);
            return this;
        }

        InternalOptionsBuilder casLocalSerial(boolean localSerial) {
            if (localSerial) {
                this.serialConsistencyO = Optional.fromNullable((Object)com.datastax.driver.core.ConsistencyLevel.LOCAL_SERIAL);
            }
            return this;
        }
    }

    public static class NoOptions
    extends Options {
        protected NoOptions() {
        }

        @Override
        public NoOptions duplicateWithoutTtlAndTimestamp() {
            return this;
        }
    }
}

